# CVE-2025-6440
WooCommerce Designer Pro <= 1.9.26 - Unauthenticated Arbitrary File Upload

## Description
WooCommerce Designer Pro plugin for WordPress, used by the Pricom - Printing Company & Design Services WordPress theme, is vulnerable to arbitrary file uploads due to missing file type validation in the 'wcdp_save_canvas_design_ajax' function in all versions up to, and including, 1.9.26. This makes it possible for unauthenticated attackers to upload arbitrary files on the affected site server which may make remote code execution possible.

- Vulnerable component: WordPress plugin Canvas Designer (AJAX action `wcdp_save_canvas_design_ajax`)
- CVE: CVE-2025-6440
- CVSS: 9.8 (critical)

## Vulnerability Details
WooCommerce Designer Pro plugin accepts file uploads via AJAX without proper checks on file content or extension. An attacker can upload a PHP payload disguised as an image file, gain remote code execution, and take control of the WordPress site.

The attack steps include:
- Sending a crafted POST request to `wp-admin/admin-ajax.php` with the `wcdp_save_canvas_design_ajax` action and malicious payload.
- File is stored under `wp-content/uploads` in a predictable path.
- The attacker then accesses the uploaded PHP file to execute code remotely.

## Requirements
- Python 3.8 or higher
- Requests library

Install dependencies:   
pip install -r requirements.txt

## Usage

- `--url`: The base URL of the WordPress site (e.g., https://example.com)
- `--file`: The PHP payload to upload
- `--verbose`: Optional flag to enable detailed debug output

Example:

```
python3 CVE-2025-6440.py --url https://vulnerablesite.com --file <payload_file> 
```


## Mitigation
Update the Canvas Designer plugin to the latest version where this vulnerability is patched. Alternatively, restrict direct file uploads and ensure proper validation of uploaded file contents in the plugin.

Site administrators are advised to:
- Remove vulnerable versions immediately.
- Apply security hardening, e.g., disable PHP execution in upload directories.
- Use Web Application Firewalls (WAF) to block malicious AJAX requests.

