
## **Product Info**

Snipe-IT is a free and open-source IT asset management system (FOSS) built on **Laravel**. It provides hardware asset tracking, software license management, accessories, and consumables inventory features for IT operations teams. It is actively maintained and updated frequently.

### **Summary**

A reflected cross-site scripting (XSS) vulnerability exists in **Snipe-IT v8.3.4 (build 202118)** within the CSV import workflow. When an invalid CSV file is uploaded, the application returns a **progress_message** value that is rendered as raw HTML in the admin interface. An attacker can intercept and modify the **POST `/livewire/update`** request and inject arbitrary JavaScript into the **progress_message** parameter.

Because the server does not sanitize or validate this field before reflecting it back to the client, the injected payload executes in the browser of any authenticated admin viewing the Import page, leading to arbitrary JavaScript execution in a privileged context.

## **Affected Product**

- **Product:** snipe-it - v8.3.4
- **Vendor:** Grokability
- **Repository:** [https://github.com/grokability/snipe-it](https://github.com/grokability/snipe-it)

## **Affected Component**

- CSV Import UI (`/import`)
- Livewire frontend component
- POST `/livewire/update` request payload
- `progress_message` variable

## **CVSS v3.1 Base Score**

AV:N/AC:L/PR:H/UI:R/S:U/C:H/I:H/A:L
<img width="966" height="216" alt="Pasted image 20251117030626" src="https://github.com/user-attachments/assets/02613a61-8927-48d2-8d69-7b7c6ccd116b" />




## **Attack Vector**

An attacker must cause the admin to upload an invalid CSV file (or simulate the workflow). During the process, the client sends a Livewire update containing the `progress_message` field. By intercepting this request via a proxy (Burp Suite, MitM, etc.), the attacker can modify the request body and inject JavaScript into the `progress_message`.

The server accepts the modified input **without sanitization** and reflects the tainted value directly back into rendered HTML. When the admin loads or refreshes the import status screen, the injected payload executes.


```json
<iframe src=\"javascript:alert('XsS By CyberCrew')\>
```
## **Impact**

* Execution of arbitrary JS with admin privileges
* Installation of malicious browser-based payloads
* Alteration of Snipe-IT assets, users, or settings


## **Steps to Reproduce (PoC)**

1. Log into Snipe-IT as an admin.
2. Navigate to **Admin → Import**.
3. Upload an intentionally invalid CSV file.

<img width="1118" height="600" alt="Pasted image 20251117024547" src="https://github.com/user-attachments/assets/2f28af9c-d669-4d77-ab31-ed79b7b39c66" />


4. Intercept the **POST** request to:

```bash
/livewire/update
```

<img width="1113" height="607" alt="Pasted image 20251117024846" src="https://github.com/user-attachments/assets/7aa1a0b0-0e82-4a9f-8e4a-1870ffe46e79" />


5. Modify the `progress_message` value:
```json 
{"progress_message":"<iframe src=\"javascript:alert('XsS By CyberCrew')\>"}
```

6. Allow the request to proceed.
7. When the admin returns to the import status view, the JavaScript executes.
<img width="1108" height="496" alt="Pasted image 20251117025423" src="https://github.com/user-attachments/assets/8e8e26f4-a02a-4618-875a-70bc97f4f085" />
<img width="1116" height="599" alt="Pasted image 20251117025459" src="https://github.com/user-attachments/assets/39764fb3-5680-4fcf-b63b-f22fd427ca13" />





## **References**

[https://nvd.nist.gov/vuln/detail/CVE-2025-24576](https://nvd.nist.gov/vuln/detail/CVE-2025-24576)

## **Discoverer**

株式会社CyberCrew / サイバークル

✉️ お問い合わせ先
ご質問・ご相談などございましたら、お気軽にご連絡ください。

🏢 株式会社CyberCrew
G1@4x
📞 Tel： 03-6853-5823
📧 Mail：info@cybercrew.co.jp

📄 会社概要
項目	内容
会社名	株式会社CyberCrew
所在地	東京都千代田区外神田1-18-13 秋葉原ダイビル6階
🔐 主なサービス
🛡️ セキュリティ診断・リスク評価
組織の脆弱性を多角的に分析し、最適な改善策を提案します。

💻 ペネトレーションテスト
標的型・シナリオ型・LLMペンテスト まで対応。

🌒 ダークウェブモニタリング
機密情報の流出を早期に検知し、迅速に対応。

🎯 REDチーム演習・ソーシャルエンジニアリング
実践的な攻撃シナリオに基づく防御力評価を実施。

🧠 セキュアシステム設計・コンサルティング
開発初期段階からセキュリティを考慮した設計を支援します。

🌐 公式サイト：https://www.cybercrew.co.jp
🕒 CyberCrew — Your Trusted Security Partner.
