# CVE-2025-63735 – Reflected XSS in Ruckus Unleashed 200.13.6.1.319

## Summary
A reflected cross-site scripting (XSS) vulnerability exists in Ruckus Unleashed 200.13.6.1.319 via the `name` parameter to the captive-portal endpoint `selfguestpass/guestAccessSubmit.jsp`.

## Vendor
Ruckus Wireless

## Product
Controller-less Systems (RUCKUS Unleashed)

## Affected Version
200.13.6.1.319

## Vulnerable Endpoint
`/selfguestpass/guestAccessSubmit.jsp`

## Parameter
`name`

## Proof of Concept
`https://192.168.1.51/selfguestpass/guestAccessSubmit.jsp?cookie=null&tip=5&name=</p><form><iframe &#09;&#10;&#11; src="javascript&#58;alert('huthx')"&#11;&#10;&#09;;>`
![xss](https://github.com/user-attachments/assets/0873ea26-21b2-4012-a31d-89741c700ad4)

## Description
The application reflects unsanitized user-controlled input from the `name` parameter back into the page response, enabling arbitrary JavaScript execution.

## Impact
An attacker can execute JavaScript in the victim’s browser, leading to session hijacking, credential theft, forced redirection, or UI manipulation.

## Discoverer
Huthaifa Qashou

## References
- https://www.ruckusnetworks.com/products/network-control-and-management/controller-less/
- CVE-2025-63735 (MITRE) – Pending publication

## Disclosure Timeline
- Reported to vendor: 24 October 2025
- CVE reserved: 12 November 2025
- Public disclosure: 24 November 2025
