
# CVE-2025-63666 — Tenda AC15

## Summary
Tenda AC15 firmware V15.03.05.18_multi issues an authentication cookie in the form `password=<MD5(password)><6-char suffix>` and returns it without `HttpOnly`, `Secure`, or `SameSite` flags, exposing the password hash to the client.  
The low-entropy suffix acts as a predictable session identifier, allowing attackers to replay or hijack sessions.  

## Impact
- Exposure of user password hashes to clients.  
- Replay or session hijacking via predictable cookie values.  
- Offline brute-force attacks possible using MD5 hash prefix.  

## Technical Details / Example
- `/login/Auth` issues a cookie `password=<MD5(password)><6-char suffix>`.  
- Cookie lacks security flags (`HttpOnly`, `Secure`, `SameSite`).  
- The cookie can be accessed via JavaScript (`document.cookie`) and reused in requests to `/main.html`.  
- Example:
  ```bash
  PW_HASH=$(echo -n 'ringzer0' | md5sum | cut -d' ' -f1)
  curl -v --compressed -c cookies.txt -D headers.txt -X POST \
    "http://192.168.141.128:20080/login/Auth" \
    -H "Content-Type: application/x-www-form-urlencoded; charset=UTF-8" \
    --data "username=admin&password=${PW_HASH}"
  COOKIE=$(awk 'NF && $0!~/^#/ {print $6"="$7; exit}' cookies.txt)
  curl -s -i -H "Cookie: ${COOKIE}" "http://192.168.141.128:20080/main.html" | sed -n '1,40p'
  ```

## Mitigation / Recommendations
1. Do not include password hashes in cookies.  
2. Generate random session tokens (≥128 bits) on the server side.  
3. Add `HttpOnly`, `Secure`, and `SameSite` flags to authentication cookies.  
4. Use secure hash functions (bcrypt, Argon2).  
5. Implement session expiration and invalidation on logout.

## References
- [NVD Entry](https://nvd.nist.gov/vuln/detail/CVE-2025-63666)
- [CVE.org Entry](https://www.cve.org/CVERecord?id=CVE-2025-63666)

---

# 권고문
Tenda AC15 펌웨어 V15.03.05.18_multi 버전은 `password=<MD5(password)><6자리 접미사>` 형태의 인증 쿠키를 발급하며, `HttpOnly`, `Secure`, `SameSite` 플래그 없이 반환하여 비밀번호 해시가 클라이언트에 노출됩니다.  
짧은 엔트로피의 접미사는 예측 가능한 세션 식별자로 작동하여 세션 재사용 또는 하이재킹이 가능합니다.  

## 영향
- 사용자 비밀번호 해시가 클라이언트에 노출됨.  
- 예측 가능한 쿠키 값으로 세션 재사용 또는 탈취 가능.  
- MD5 해시를 이용한 오프라인 크래킹 가능.

## 기술적 세부사항 / 예시
- `/login/Auth`는 `password=<MD5(password)><6자리 접미사>` 형태의 쿠키를 발급함.  
- 쿠키에는 `HttpOnly`, `Secure`, `SameSite` 플래그가 없음.  
- 자바스크립트(`document.cookie`)로 쿠키를 읽어 `/main.html` 요청 시 재사용 가능.  
- 예시:
  ```bash
  PW_HASH=$(echo -n 'ringzer0' | md5sum | cut -d' ' -f1)
  curl -v --compressed -c cookies.txt -D headers.txt -X POST \
    "http://192.168.141.128:20080/login/Auth" \
    -H "Content-Type: application/x-www-form-urlencoded; charset=UTF-8" \
    --data "username=admin&password=${PW_HASH}"
  COOKIE=$(awk 'NF && $0!~/^#/ {print $6"="$7; exit}' cookies.txt)
  curl -s -i -H "Cookie: ${COOKIE}" "http://192.168.141.128:20080/main.html" | sed -n '1,40p'
  ```

## 완화 권고
1. 쿠키에 비밀번호 해시를 포함하지 말 것.  
2. 서버에서 128비트 이상 암호학적 난수로 세션 토큰을 생성할 것.  
3. 인증 쿠키에 `HttpOnly`, `Secure`, `SameSite` 플래그를 적용할 것.  
4. bcrypt 또는 Argon2 등 안전한 해시 알고리즘 사용.  
5. 세션 만료 및 로그아웃 시 무효화 기능 적용.

## 참고
- [NVD 등록정보](https://nvd.nist.gov/vuln/detail/CVE-2025-63666)
- [CVE.org 등록정보](https://www.cve.org/CVERecord?id=CVE-2025-63666)
