# CVE-2025-63353: Predictable Wi-Fi Password Vulnerability in FiberHome GPON ONT Devices

## References

Based on research by Hanianis (original CVE disclosure at [CVE-2025-63353](https://github.com/hanianis/CVE-2025-63353))
Thanks to the security researchers who identified this vulnerability.

## Legal Disclaimer

This information is provided for educational and security research purposes only. Users are responsible for compliance with all applicable local, state, and federal laws. The authors assume no liability for any damages arising from the use or misuse of this information.

## Summary

A critical vulnerability has been identified in FiberHome GPON ONU HG6145F1 RP4423 devices that allows an attacker to predict the factory default Wi-Fi password (WPA/WPA2 pre-shared key) using only the SSID. The device generates default passwords using a deterministic algorithm that derives the router passphrase from the SSID, enabling an attacker who can observe the SSID to predict the default password without authentication or user interaction. 

## Technical Details

### Vulnerability Description

The FiberHome GPON ONU HG6145F1 RP4423 uses a predictable algorithm to generate default Wi-Fi credentials:

- **SSID Format**: `fh_<HEX_A>` (where fh_ is the prefix followed by a hexadecimal value)
- **Password Format**: `wlan<HEX_B>` (where wlan is the prefix followed by a hexadecimal value)

The relationship between the SSID and password hex values follows this deterministic formula:
```
HEX_A + HEX_B = 0xFFFFFF
Therefore: HEX_B = 0xFFFFFF - HEX_A
```

### Attack Methodology

1. Observe the target device's SSID (e.g., `fh_AAAAAA`)
2. Extract the hexadecimal portion from the SSID (e.g., `AAAAAA`)
3. Calculate the corresponding password hex value: `HEX_B = 0xFFFFFF - SSID_HEX`
4. Construct the default password using the wlan prefix: `wlan` + calculated hex value

## Affected Products

- **Vendor**: FiberHome
- **Product**: GPON ONU HG6145F1 - RP4423
- **Affected Component**: Firmware
- **Vulnerability Type**: Default Credentials (Predictable Password Generation)



## Using the Proof of Concept

### Prerequisites
- Go 1.25.4 or higher
- Network adapter with monitor mode capabilities (for live scanning)
- One of the following tools must be available: `nmcli` (Linux), `netsh` (Windows), or `airport` (macOS)
- Note: The implementation may include custom string parsing functions (note: some functions referenced in code may require additional dependencies)

### Installation
```bash
# Clone the repository
git clone https://github.com/0xA1M/CVE-2025-63353.git
cd CVE-2025-63353

# Install dependencies
go mod tidy
```

### Usage
```bash
# Basic scan
go run poc.go
```
