# CVE-2025-62726 POC - n8n Git Node RCE

## Educational Purpose
This is a proof-of-concept demonstration for CVE-2025-62726, created for educational purposes as part of a class project.
Part of CMU Course : 18-739 Hacking & Offensive Security in Fall 2025

## Vulnerability Overview

**CVE ID:** CVE-2025-62726
**Severity:** CVSS 8.8 (High)
**Affected Software:** n8n (workflow automation platform)
**Vulnerable Versions:** < 1.113.0
**Vulnerability Type:** Remote Code Execution (RCE) via Git Hooks
**CWE Classification:** CWE-829 (Inclusion of Functionality from Untrusted Control Sphere)

## Technical Details

### How It Works

1. **Attack Vector:** Git pre-commit hooks in cloned repositories
2. **Trigger:** When n8n's Git Node performs a commit operation
3. **Execution:** Git automatically executes the pre-commit hook with n8n process privileges
4. **Impact:** Arbitrary code execution, credential theft, workflow manipulation

### Root Cause

n8n's Git Node fails to sanitize or isolate git hooks when cloning untrusted repositories. When a workflow:
- Clones a repository containing malicious `.git/hooks/pre-commit`
- Performs a commit operation
- Git automatically executes the hook script

### Repo Content
- docker.compose.yml (for creating the docker instance with vulnerable n8n)
- Deploy Application to Production - Backup.yml (n8n workout with nodejs reverse shell)
- pre-commit (contained nodejs reverse shell, put it on .git/hooks/ dir)
