/*
 * System Information Utility
 * Gathers information about the target system for exploit compatibility
 */

#include <windows.h>
#include <iostream>
#include <string>

void PrintSystemInfo() {
    std::cout << "========================================" << std::endl;
    std::cout << "System Information" << std::endl;
    std::cout << "========================================" << std::endl;

    // OS Version
    OSVERSIONINFOEXW osvi = {0};
    osvi.dwOSVersionInfoSize = sizeof(OSVERSIONINFOEXW);
    
    if (GetVersionExW((OSVERSIONINFO*)&osvi)) {
        std::wcout << L"OS Version: " << osvi.dwMajorVersion << L"." 
                   << osvi.dwMinorVersion << std::endl;
        std::wcout << L"Build Number: " << osvi.dwBuildNumber << std::endl;
        
        if (osvi.dwMajorVersion == 10) {
            if (osvi.dwMinorVersion == 0) {
                std::cout << "OS: Windows 10 or Windows 11" << std::endl;
            }
        }
    }

    // Architecture
    SYSTEM_INFO si;
    GetNativeSystemInfo(&si);
    std::cout << "Architecture: ";
    switch (si.wProcessorArchitecture) {
        case PROCESSOR_ARCHITECTURE_AMD64:
            std::cout << "x64" << std::endl;
            break;
        case PROCESSOR_ARCHITECTURE_INTEL:
            std::cout << "x86" << std::endl;
            break;
        case PROCESSOR_ARCHITECTURE_ARM64:
            std::cout << "ARM64" << std::endl;
            break;
        default:
            std::cout << "Unknown" << std::endl;
    }

    // Privilege check
    std::cout << "Current Privileges:" << std::endl;
    if (IsUserAnAdmin()) {
        std::cout << "  - Administrator: Yes" << std::endl;
    } else {
        std::cout << "  - Administrator: No" << std::endl;
    }

    HANDLE hToken;
    if (OpenProcessToken(GetCurrentProcess(), TOKEN_QUERY, &hToken)) {
        TOKEN_ELEVATION elevation;
        DWORD dwSize;
        
        if (GetTokenInformation(hToken, TokenElevation, &elevation, sizeof(elevation), &dwSize)) {
            std::cout << "  - Token Elevated: " 
                      << (elevation.TokenIsElevated ? "Yes" : "No") << std::endl;
        }
        
        CloseHandle(hToken);
    }

    // Memory info
    MEMORYSTATUSEX memInfo;
    memInfo.dwLength = sizeof(MEMORYSTATUSEX);
    if (GlobalMemoryStatusEx(&memInfo)) {
        std::cout << "Memory:" << std::endl;
        std::cout << "  - Total Physical: " 
                  << (memInfo.ullTotalPhys / (1024 * 1024)) << " MB" << std::endl;
        std::cout << "  - Available Physical: " 
                  << (memInfo.ullAvailPhys / (1024 * 1024)) << " MB" << std::endl;
    }

    std::cout << "========================================" << std::endl;
}

// Check if system is potentially vulnerable
bool CheckVulnerability() {
    OSVERSIONINFOEXW osvi = {0};
    osvi.dwOSVersionInfoSize = sizeof(OSVERSIONINFOEXW);
    
    if (!GetVersionExW((OSVERSIONINFO*)&osvi)) {
        return false;
    }

    // CVE-2025-62215 affects Windows 10/11
    // This is a simplified check - actual check would verify build numbers
    if (osvi.dwMajorVersion == 10) {
        std::cout << "[*] System appears to be potentially vulnerable" << std::endl;
        std::cout << "[*] Note: Actual vulnerability depends on patch level" << std::endl;
        return true;
    }

    std::cout << "[!] System may not be vulnerable to CVE-2025-62215" << std::endl;
    return false;
}

int main() {
    PrintSystemInfo();
    std::cout << std::endl;
    CheckVulnerability();
    return 0;
}

