# Quick Start Guide

## Prerequisites

1. **Windows Development Environment**
   - Visual Studio 2019 or later
   - Windows SDK
   - (Optional) Windows Driver Kit (WDK)

2. **Test Environment**
   - A Windows 10/11 test system (VM recommended)
   - Local user account with standard privileges
   - **IMPORTANT**: Only test on systems you own or have explicit permission

## Step 1: Check System Compatibility

```bash
# Build and run system info utility
system_info.exe
```

This will show:
- Windows version and build number
- System architecture
- Current privilege level
- Whether the system might be vulnerable

## Step 2: Build the Exploit

### Option A: Using Build Script (Recommended)
```bash
# Open Visual Studio Developer Command Prompt
# Navigate to project directory
build.bat
```

### Option B: Manual Build
```bash
# Main exploit
cl.exe /EHsc /O2 exploit.cpp /link /SUBSYSTEM:CONSOLE /OUT:exploit.exe

# Advanced module (optional)
cl.exe /EHsc /O2 advanced_exploit.cpp /link /SUBSYSTEM:CONSOLE /OUT:advanced_exploit.exe

# System info (optional)
cl.exe /EHsc /O2 system_info.cpp /link /SUBSYSTEM:CONSOLE /OUT:system_info.exe
```

## Step 3: Run the Exploit

### Test Mode (Safest)
```bash
exploit.exe --test
```
This verifies the code can initialize without attempting full exploitation.

### Full Exploitation
```bash
# Standard execution
exploit.exe

# With verbose output
exploit.exe --verbose
```

## Step 4: Verify Results

After running the exploit:

1. **Check Privilege Level**
   ```bash
   # In a new command prompt
   whoami /priv
   ```

2. **Verify SYSTEM Access**
   - Try accessing protected system directories
   - Check if you can modify system files
   - Verify process privileges in Task Manager

## Troubleshooting

### Build Errors

**Error: "cl.exe not found"**
- Solution: Run from Visual Studio Developer Command Prompt
- Or manually set up the build environment variables

**Error: "Cannot open include file"**
- Solution: Install Windows SDK
- Verify SDK path in Visual Studio Installer

### Runtime Issues

**"Race condition not triggered"**
- The exploit may require multiple attempts
- System might be patched
- Try running with different thread counts (modify code)

**System Crashes (BSOD)**
- This is expected behavior for kernel exploits
- Use a VM for testing
- Ensure you have snapshots/backups

**"Already running with elevated privileges"**
- The exploit detects you're already admin
- Test with a standard user account instead

## Important Notes

1. **Reliability**: Kernel race condition exploits are inherently unreliable
   - Success rate may be low (10-30% typical)
   - Multiple attempts may be needed
   - System crashes are possible

2. **Detection**: This exploit may be detected by:
   - Antivirus software
   - EDR solutions
   - Windows Defender
   - Consider testing in isolated environment

3. **Patching**: If the system is patched:
   - Exploit will fail safely
   - No privilege escalation will occur
   - System should remain stable

## Next Steps

- Review `TECHNICAL_DETAILS.md` for in-depth analysis
- Examine the code to understand the vulnerability
- Consider developing detection rules based on exploit behavior
- Test mitigation strategies

## Getting Help

- Review the code comments for implementation details
- Check `TECHNICAL_DETAILS.md` for technical analysis
- Consult Windows kernel documentation for deeper understanding

## Safety Reminders

⚠️ **Always**:
- Test in isolated VMs
- Use snapshots before testing
- Only test on systems you own
- Follow responsible disclosure practices

❌ **Never**:
- Test on production systems
- Use on systems without permission
- Share exploit code without warnings
- Use for malicious purposes

