# 🧪 CVE-2025-6218: Path Traversal en WinRAR

## 📌 Descripción

Este laboratorio demuestra cómo explotar la vulnerabilidad **CVE-2025-6218** en versiones vulnerables de **WinRAR** para Windows. Esta vulnerabilidad permite que un archivo `.rar` malicioso sobrescriba archivos fuera del directorio de extracción usando rutas relativas (`..\..\`), lo que puede llevar a la ejecución de código o la manipulación de archivos sensibles.

> ⚠️ **Este laboratorio es solo con fines educativos.** Debe ejecutarse en una **máquina virtual aislada**, sin conexión a redes productivas.

---

## 🛡️ Versiones Vulnerables

La vulnerabilidad afecta a:

- **WinRAR 7.11 y anteriores** (incluyendo versiones 6.x y algunas 5.x).
- Las versiones vulnerables no filtran correctamente las rutas relativas (`..\..\`) durante la extracción.
- **No afecta** a WinRAR 7.12 y posteriores.

Se recomienda encarecidamente actualizar a [WinRAR 7.12](https://www.win-rar.com/download.html) o superior.

---

## 🎯 Objetivo del Laboratorio

- Entender el concepto de Path Traversal en archivos comprimidos.
- Observar cómo un archivo `.rar` manipulado puede sobrescribir archivos fuera del destino.
- Destacar la importancia de mantener el software actualizado.

---

## 🧰 Requisitos

- Máquina virtual con Windows 10 u 11.
- WinRAR 7.11 o anterior.
- Archivo de prueba: `C:\Users\victima\Desktop\importante.txt`
- WinRAR instalado o ejecutable (`winrar.exe`).
- Archivo malicioso `archivo_exploit.rar` (incluido en este ZIP).

---

## 🛠️ Preparación del Entorno

1. **Instalar WinRAR vulnerable** (por ejemplo 7.11).
2. **Crear archivo legítimo a sobrescribir**:
    ```powershell
    echo Archivo legítimo > "C:\Users\victima\Desktop\importante.txt"
    ```

3. **Extraer `archivo_exploit.rar`** desde este laboratorio en cualquier carpeta (por ejemplo, `C:\temp`).

4. **Abrir el `.rar` con WinRAR** y extraerlo a un directorio cualquiera. El archivo será extraído con una ruta como:

    ```
    ..\..\Users\victima\Desktop\importante.txt
    ```

    Lo que resultará en que el archivo original será sobrescrito.

---

## 🔍 Qué se debe observar?

- Antes de la extracción: `importante.txt` dice “Archivo legítimo”.
- Después de extraer el `.rar` malicioso: dice “MALWARE INYECTADO”.
- La extracción no ocurrió en el escritorio, pero el archivo fue sobrescrito debido a la ruta relativa.

---

## ✅ Solución

Actualizar WinRAR a la versión **7.12 o superior**.

---

## 🧪 Contenido del Repositorio

| Archivo                     | Descripción                                               |
|----------------------------|-----------------------------------------------------------|
| `archivo_exploit.rar`      | Archivo comprimido con ruta de escape (`..\..\`)        |
| `importante.txt`           | Archivo legítimo antes del ataque                         |
| `crear_rar_malicioso.bat`  | Script demostrativo para generar el `.rar` (si se desea)  |
| `README.md`                | Esta guía paso a paso                                     |

---

## 🧑‍🏫 Autor

Explicación elaborada por [Sebastian Peinador](https://www.linkedin.com/in/sebastian-j-peinador/) para propósitos didácticos y de investigación en ciberseguridad ofensiva.

---

## 📄 Licencia

Este material se distribuye bajo la licencia [MIT](LICENSE).

---

> Si te resulta útil, ¡no olvides darle ⭐ al repo o compartirlo!
