### CVE-2025-62168 — Squid Proxy Token Leak PoC

The author assumes no liability for misuse or damage caused by this tool. 
Research is provided strictly for educational and defensive purposes.

---

## Description

This repository contains a Proof-of-Concept (PoC) for **CVE-2025-62168** , an information-disclosure flaw affecting **Squid Proxy**.
Under certain configurations, Squid may **reflect HTTP request headers** inside its auto-generated *error pages*, specifically within the **mailto:** diagnostic block.

This behavior can expose sensitive tokens such as:

- JWT Bearer tokens 
- API keys
- Custom authentication headers

The PoC demonstrates how a single injected header can appear unredacted inside the error template, allowing an attacker to retrieve the leaked token through a forced network error.

## Technical Summary

This vulnerability arises from the way Squid generates and returns error pages. When an error occurs, Squid’s response may unintentionally embed sensitive HTTP authentication data inside the administrator mailto link created through the email_err_data directive.

Systems are affected whenever email_err_data is enabled — including default configurations — and exposure can occur even if Squid is not explicitly configured to use HTTP authentication.

The issue is classified under:

- CWE-209: Generation of Error Message Containing Sensitive Information
- CWE-550: Server-Generated Error Message Containing Sensitive Information

This makes the flaw especially critical, as leaked credentials may belong to internal applications, backend services, or authenticated clients relying on Squid as a proxy layer.

When Squid builds an error page (e.g., `ERR_READ_ERROR`), the internal template may include:

```
HTTP Request:
Header: VALUE
```

If sanitization fails, the **user-supplied header** is inserted into the `mailto:` hyperlink used for diagnostics. This PoC triggers an error using a non-existent domain and inspects the returned HTML for unredacted data.

## Impact

The vulnerability enables an attacker to bypass normal browser security controls and extract authentication credentials used by trusted clients. This includes tokens and session data belonging to internal web applications or backend services, especially in environments where Squid operates as a reverse proxy or load balancer. By capturing this information directly from Squid’s generated error pages, an attacker could impersonate legitimate users, escalate access, move laterally within the network, or compromise backend systems that rely on Squid for traffic handling.


## Root Cause

- Squid includes request metadata in its error templates
- Sanitization does not remove all custom headers
- Token-containing headers appear inside the `mailto:` body (URL-encoded)
- A remote client can retrieve the entire block from the proxy response


### Affected Versions

- Versions **< 7.2** are potentially affected  
- Behavior confirmed on **Squid 5.x**, **6.x**, **7.1**


## CVSS v3.1 Vector (Proposed)

```
CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:N/A:N
Score: 7.5  (High)
```


## PoC Usage

```bash
python3 cve-2025-62168.py --proxy http://127.0.0.1:3128
```

Technical mode:

```bash
python3 cve-2025-62168.py --proxy http://127.0.0.1:3128 --verbose
```

The script performs:

1. Connects to the proxy 
2. Sends a request containing a controlled token
3. Forces Squid to generate an error page
4. Parses the `mailto:` diagnostic block 
5. Extracts the leaked token
6. Decodes the JWT (header, payload, signature)


## Example Output (Truncated)

```
STEP 4 — Parsing mailto block...
X-Test-Leak: <JWT TOKEN>

STEP 5 — TOKEN LEAK CONFIRMED
<decoded token>
```

## Repository Structure

```
CVE-2025-62168/
│
├── LICENSE
├── README.md
├── cve-2025-62168.py
├── example.txt
├── payload.json
├── requirements.txt
└── token.txt
```

## Mitigation

- Upgrade Squid to **7.2 or later**
- Disable unnecessary custom headers
- Prevent clients from sending arbitrary Authorization-like fields
- Review error-page templates (`ERR_*`) for leaked metadata
- Review squid.conf | email_err_data off <- IMPORTANT


## Author

- Researcher: krakhen.dev 
- GitHub: https://github.com/nehkark
- Email: krakhen@gmail.com 
- Website: https://vciso.cloud
- ICQ: 24298753 👾
- Reference: https://github.com/monzaviman/CVE-2025-62168/

