# CVE-2025-61922 Exploit: PrestaShop Checkout Account Takeover

A simple, educational proof-of-concept script demonstrating the zero-click account takeover vulnerability in the PrestaShop Checkout module (CVE-2025-61922).

**⚠️ Legal & Ethical Notice: Use Responsibly**
This tool is for **educational purposes and authorized security testing only**. Use only against systems you own or have explicit written permission to test. Unauthorized access to computer systems is illegal.

## Overview

This vulnerability, tracked as CVE-2025-61922 with a CVSS score of 9.1 (Critical), affects PrestaShop Checkout module versions **below 5.0.5**. It allows an unauthenticated attacker to log in as any customer account by simply knowing the victim's email address—a true "zero-click" attack.

## How It Works

The script sends a specially crafted POST request to the vulnerable endpoint:
- **Endpoint**: `/module/ps_checkout/ExpressCheckout`
- **Method**: POST
- **Payload**: JSON containing the victim's email address

When successful, the server responds with session cookies for the victim's account, which can be used to hijack their session.

## Files in This Repository

- `CVE-2025-61922.py` - Main exploit script
- `README.md` - This documentation

## Quick Start

1. **Basic usage**:
```bash
# Check if a target is vulnerable
python CVE-2025-61922.py check --url http://target-shop.com

# Exploit a specific email
python CVE-2025-61922.py takeover --url http://target-shop.com --email victim@example.com

# Test captured cookies
python CVE-2025-61922.py test --url http://target-shop.com --cookies "PrestaShop-abc123=..."