# Summary

A remote code execution vulnerability in python-socketio versions prior to 5.14.0 allows attackers to execute arbitrary Python code through malicious pickle deserialization in multi-server deployments on which the attacker previously gained access to the message queue that the servers use for internal communications.
You can find a detailed analysis of this vulnerability in the [GitHub Advisory](https://github.com/miguelgrinberg/python-socketio/security/advisories/GHSA-g8c6-8fjj-2r4m).

# Run

There are three docker containers involved in this demo:
1. **Redis Server**: Acts as the message broker.
2. **Vulnerable Socket.IO Server**: A Flask-based server that uses python-socketio to handle WebSocket connections and communicates via Redis.
3. **Attacker Client**: A client that connects to the Socket.IO server and sends a malicious payload to exploit the vulnerability.

There is a `docker-compose.yml` file that orchestrates these containers. To run the demo, execute the following command in the directory containing the `docker-compose.yml` file:

```bash
docker-compose up --build
```

This command will build and start all three containers. The Socket.IO server will be accessible at `http://localhost:5000`, and the attacker client will automatically attempt to exploit the vulnerability upon startup. You can check the `evidence` directory for any files created by the exploit in the socketio_server container.