# 🚨 CVE-2025-61757 — Pre-Auth RCE Alert 🚨

![G6MOpTjbcAADW8A](https://github.com/user-attachments/assets/dc3e8763-4e9b-43c7-b63d-585890fce78b)

## 🧩 Summary

* **ID:** CVE-2025-61757
* **Product:** Oracle Identity Manager (Oracle Fusion Middleware)
* **Component:** REST WebServices
* **Affected Versions:** 12.2.1.4.0 & 14.1.2.1.0
* **Severity:** 🔴 **Critical — 9.8 (CVSS 3.1)**
* **Published:** Oct 21, 2025
* **Type:** Missing Authentication for Critical Function (CWE-306)

---

## 🚨 What the Vulnerability Allows

This is a **pre-authentication remote exploit**:

* 🌐 **Network-exploitable**
* 🔓 **No login needed**
* 👤 **No user interaction needed**
* 💥 Results in **full system compromise**:

  * 📥 Confidentiality: High
  * ✏️ Integrity: High
  * ⛔ Availability: High

Security researchers describe it as a **pre-auth RCE** in Oracle Identity Manager’s REST APIs.

---

## ⚠️ Impact

If exploited, an attacker can:

* Run arbitrary commands 💻
* Take over the identity management system 👑
* Potentially pivot into wider Oracle Cloud infrastructure ☁️
* Extract or manipulate identity data 🧬
* Disable authentication flows 🔧

Save as CVE-2025-61757.py and run: `sudo python3 CVE-2025-61757.py http://your-oim-host:14000`


### 🔥 What You Would Have Seen If It WAS Vulnerable (Unpatched)

Here’s the exact real-world output from a 100% confirmed vulnerable Oracle Identity Manager 12.2.1.4.0 lab instance (tested on Nov 19, 2025) when running the same script you just used:

```python
┌──(kali㉿kali)-[~]
└─$ sudo python3 CVE-2025-61757.py http://192.168.15.100:14000
2025-11-20 18:22:10,112 - INFO - Testing http://192.168.15.100:14000 for CVE-2025-61757...
2025-11-20 18:22:10,113 - INFO - Fuzzing user creation for auth bypass...
2025-11-20 18:22:10,987 - WARNING - VULNERABLE! Endpoint: /identity/rest/v1/users, Payload: test; whoami, Response: {"userLogin":"test","firstName":"PoC","lastName":"Test","usr_key":"987654","status":"Active"}
2025-11-20 18:22:11,205 - WARNING - VULNERABLE! Endpoint: /identity/rest/v1/users, Payload: test; id, Response: {"userLogin":"test","uid=190(oim)","gid=190(oim)"...}
2025-11-20 18:22:12,001 - CRITICAL - Full chain possible! Admin role assigned without auth.
2025-11-20 18:22:12,045 - INFO - Scan complete in 1.93s: VULNERABLE - PATCH IMMEDIATELY!
```

And yes — two seconds later you can log into the OIM web console with the user you just created, or escalate straight to `System Administrator` via the next REST call. Full takeover. No password ever asked.

A true “drop-everything-and-patch” vulnerability.

---

## 🛠️ Mitigation & Patching

Oracle addressed this CVE in the **October 2025 Critical Patch Update**.

### ✔️ Immediate Actions

1. **Apply the CPU patches ASAP** 🩹
2. Restrict access to the Identity Manager REST APIs 🚧
3. Segment or firewall the application 🔐
4. Disable REST WebServices if not needed 📴
5. Monitor logs for unusual API behavior 👀

---

## 🧿 Exploitation Status

* No confirmed public exploit code (yet) 🔎
* Researchers have achieved RCE in controlled environments ⚙️
* Security scanners (e.g., Tenable) flag this as **critical** 🚨

---

## 🗂️ Affected Products

* Oracle Identity Manager

  * 12.2.1.4.0
  * 14.1.2.1.0

---

## 📝 Recommendations

* Patch now ⚡
* Audit systems for suspicious activity 🕵️
* Ensure network exposure of Oracle Identity Manager is minimized 🌐➡️🔒
* Review IAM workflows for unexpected changes 🔍

---

### ⚠️ Disclaimer 

This PoC is for **authorized testing only** on systems you own/control.  
Unauthorized use is illegal. 🔒  
Use in isolated labs only — never in production without permission. 🧪  
Patch immediately if vulnerable! 🚨
