# Contributing to CVE-2025-61246 PoC

Thank you for your interest in contributing to this security research project!

## Code of Conduct

This project is dedicated to responsible security research. By participating, you agree to:

- Use this tool only for authorized security testing
- Report vulnerabilities responsibly
- Respect privacy and data protection laws
- Not use this tool for malicious purposes

## How to Contribute

### Reporting Issues

If you find a bug or have a suggestion:

1. Check if the issue already exists
2. Create a new issue with:
   - Clear title and description
   - Steps to reproduce (if applicable)
   - Expected vs actual behavior
   - Your environment details

### Submitting Changes

1. **Fork the repository**
2. **Create a feature branch**
   ```bash
   git checkout -b feature/your-feature-name
   ```

3. **Make your changes**
   - Follow PEP 8 style guidelines
   - Add comments for complex logic
   - Update documentation if needed

4. **Test your changes**
   ```bash
   python -m pytest tests/
   ```

5. **Commit your changes**
   ```bash
   git commit -m "Add: Brief description of changes"
   ```

6. **Push to your fork**
   ```bash
   git push origin feature/your-feature-name
   ```

7. **Create a Pull Request**
   - Provide a clear description
   - Reference any related issues
   - Ensure all tests pass

## Development Setup

```bash
# Clone your fork
git clone https://github.com/yourusername/CVE-2025-61246.git
cd CVE-2025-61246

# Create virtual environment
python -m venv venv
source venv/bin/activate  # On Windows: venv\Scripts\activate

# Install dependencies
pip install -r requirements.txt
pip install -r requirements-dev.txt
```

## Coding Standards

- Follow PEP 8 style guide
- Use meaningful variable names
- Add docstrings to functions
- Keep functions focused and small
- Write unit tests for new features

## Testing

```bash
# Run all tests
python -m pytest

# Run with coverage
python -m pytest --cov=exploit

# Run specific test
python -m pytest tests/test_exploit.py::test_detection
```

## Documentation

- Update README.md for new features
- Add examples for new functionality
- Keep MANUAL_TESTING.md current
- Document security implications

## Security

If you discover a security issue in this tool:

1. **Do not** open a public issue
2. Email: security@example.com
3. Include detailed description
4. Allow time for response before disclosure

## Questions?

Feel free to open an issue for questions or discussions.

## License

By contributing, you agree that your contributions will be licensed under the MIT License.
