# Security Advisory — CVE-2025-61155
**Disclosure Date:** 2025-10-24  
**CVE ID:** CVE-2025-61155  
**Reporter(s):** Gabriel Maciel Ramos, Anthony Sforzin, Gabriel Gomes  
**Vendor:** Hotta Studio  
**Product / Component:** GameDriverX64.sys (kernel-mode driver)  
**Version(s) Affected:** 7.23.4.7 and previous versions.  
**CWE:** CWE-400 Uncontrolled Resource Consumption  
**Attack Vector:** Local  
**Privileges Required:** Local user (no additional administrative privileges required)  
**CVSS:** 5.5


## Vulnerability Description
The GameDriverX64.sys kernel-mode anti-cheat driver (v7.23.4.7 and earlier) contains an access control vulnerability in one of its IOCTL handlers. A user-mode process can open a handle to the driver device and send specially crafted IOCTL requests. These requests are executed in kernel-mode context without proper authentication or access validation, allowing the attacker to terminate arbitrary processes, including critical system and security services, without requiring administrative privileges.


## Affected Components / Technical Details
- GameDriverX64.sys (Anti-Cheat Kernel Driver) 7.23.4.7 and previous versions


## Impact
- Local Denial of Service, including termination of critical system processes such as antivirus or core system services, potentially compromising system security. No administrative privileges are required to exploit this vulnerability.


## Temporary Mitigation
- Remove or block the `GameDriverX64.sys` driver until a vendor patch is available.

## PoC
[PoC source code](poc.cpp)


## Timeline / Status
- 2026-02-08 — PoC published
- 2025-12-04 — Updated description available at CVE.org.
- 2025-10-28 — CVE published on CVE.org.
- 2025-10-24 — CVE reserved (CVE-2025-61155) by MITRE.  
- 2025-10-24 — Public advisory published by researchers.


## Contact
For coordination, secure PoC requests, or further inquiries:  
**gmaciel0204@gmail.com**


## References
- Public advisory (this document): https://github.com/pollotherunner/CVE-2025-61155/blob/main/advisory.md
- CVE record: https://www.cve.org/CVERecord?id=CVE-2025-61155
