# CVE-2025-61155: Arbitrary Process Termination in GameDriverX64.sys


https://github.com/user-attachments/assets/baf76601-94de-49a6-b4fd-e72f63112fab

## Overview

This repository contains the security advisory and PoC for CVE-2025-61155. The GameDriverX64.sys anti-cheat driver allows any local user to terminate arbitrary processes via a vulnerable IOCTL handler.

## Proof of Concept

The [PoC source code](poc.cpp) demonstrates communication with the driver to terminate a specified process.

## Disclaimer

This research is for educational and defensive purposes only. The author is not responsible for any misuse of this information. Unauthorized access to computer systems is illegal.

## References

* MITRE: [CVE-2025-61155 Record](https://www.cve.org/CVERecord?id=CVE-2025-61155)
* Advisory: [Original Discovery Document](https://github.com/pollotherunner/CVE-2025-61155/blob/main/advisory.md)
* Fortinet Threat Research: [Interlock Ransomware: New Techniques, Same Old Tricks](https://www.fortinet.com/blog/threat-research/interlock-ransomware-new-techniques-same-old-tricks)
* Technical Deep Dive: [Tower of Flaws - Vulnerability Analysis by Vespalec](https://vespalec.com/blog/tower-of-flaws/)
