# CVE-2025-60188-Atarim-Plugin-Exploit
CVE-2025-60188: Atarim Plugin Authentication Bypass via HMAC Forgery
Overview
This repository contains a Proof of Concept (PoC) and technical analysis for CVE-2025-60188, a critical vulnerability discovered in the Atarim WordPress plugin. This flaw allows unauthenticated users to bypass security measures and access sensitive system information.

Technical Description
The vulnerability stems from an insecure implementation of HMAC-based authentication. The application utilizes a predictable or leaked internal ID (site_id) as the secret key for signing requests to administrative AJAX actions.

Vulnerability Flow:
Information Leak: The site_id is exposed via a public-facing REST API endpoint.

Signature Forgery: Since the secret key (site ID) is known, an attacker can locally compute a valid Request-Signature using the HMAC-SHA256 algorithm.

Privilege Escalation: By providing the forged signature in the headers, the attacker gains access to protected functions like wpf_website_users and wpf_website_details.

Impact
Information Disclosure: Unauthorized access to user PII (names, emails, roles).

Configuration Leak: Exposure of system settings and potential license keys.

Remediation
Users should update the Atarim plugin to the latest patched version immediately. Developers are advised to use high-entropy secrets (e.g., wp_salt()) and implement constant-time comparison for signature validation.

![image](https://github.com/m4sh-wacker/CVE-2025-60188-Atarim-Plugin-Exploit/blob/main/image.png?raw=true)

Run Exploit
```bash
pip install requests urllib3
python3 CVE-2025-60188.py
```
