# CVE-2025-59718 Exploit Wizard

## Overview

This tool is a proof-of-concept (PoC) exploit script for CVE-2025-59718, a critical authentication bypass vulnerability in Fortinet products (e.g., FortiOS, FortiProxy, FortiSwitchManager) due to improper verification of cryptographic signatures in SAML messages for FortiCloud SSO. The vulnerability allows unauthenticated remote attackers to bypass authentication and gain administrative access by crafting and submitting an unsigned SAML response.

**Important Note:** This script is intended for educational, research, and authorized testing purposes only. Unauthorized use against systems without explicit permission is illegal and unethical. Always comply with applicable laws and obtain proper authorization before testing.

The script supports single or bulk target scanning, optional proxy usage, SAML token replay and session hijacking simulations, and post-authentication actions like configuration file downloads. It uses multi-threading for efficiency and logs results to files for analysis.

## Disclaimer

- **Security Advisory:** Refer to Fortinet's official advisory (FG-IR-25-647) for details on affected versions, patches, and mitigations.
- **Active Exploitation:** As of December 22, 2025, this vulnerability is actively exploited in the wild. Patch immediately or disable FortiCloud SSO.
- **Ethical Use:** This PoC demonstrates the vulnerability's impact to raise awareness. Do not use it on production systems or without permission. The author assumes no liability for misuse.
- **Mitigation Recommendation:** Upgrade to fixed versions (e.g., FortiOS 7.4.9 or later) and disable FortiCloud SSO via CLI:  
  ```
  config system global
  set admin-forticloud-sso-login disable
  end
  ```

## Features

- **Target Modes:** Single target, comma-separated list, or file-based input.
- **Multi-Threading:** Parallel processing for bulk scans (default: 10 threads).
- **Proxy Support:** Route traffic through a proxy (e.g., for Burp Suite interception).
- **SAML Payload Generation:** Dynamically crafts unsigned SAML responses for bypass.
- **Vulnerability Check:** Verifies success via HTTP status and response keywords.
- **Post-Auth Actions:** Optional download of system configuration files.
- **Replay & Hijacking:** Simulate SAML token replay and SSO session hijacking (using provided token).
- **Logging & Output:** Detailed console logs, vulnerable targets saved to TXT, reports to CSV.
- **Command-Line Interface:** Flexible arguments for non-interactive use.

## Requirements

- **Python Version:** 3.8 or higher.
- **Dependencies:** Install via `pip`:
  ```
  pip install requests argparse
  ```
  (The script uses standard libraries for most functionality; no additional installs needed beyond these.)
- **Environment:** Tested on Linux, macOS, and Windows. Ensure network access to targets.
- **Permissions:** Run with sufficient privileges for file I/O (e.g., writing logs and configs).

## Installation

1. Clone or download the script (e.g., `exploit.py`).
2. Install dependencies:
   ```
   pip install -r requirements.txt
   ```
   (Create `requirements.txt` with: `requests` and `argparse` if needed.)
3. Ensure the script is executable (on Unix-like systems):
   ```
   chmod +x exploit.py
   ```

## Usage

Run the script with Python:
```
python exploit.py [options]
```

### Command-Line Arguments

- `--target <IP/hostname>`: Single target to scan (e.g., `192.168.1.1` or `example.com`).
- `--targets <comma-separated list>`: Multiple targets (e.g., `192.168.1.1,example.com`).
- `--file <path>`: File with one target per line.
- `--username <name>`: Username to impersonate in SAML payload (default: `admin`).
- `--endpoint <path>`: SAML login endpoint (default: `/remote/saml/login`).
- `--max-threads <int>`: Maximum concurrent threads (default: 10; max recommended: 50).
- `--saml-token <token>`: Base64-encoded SAML token for replay/hijacking (optional).
- `--proxy <url>`: Proxy URL (e.g., `http://127.0.0.1:8080`).
- `--post-auth-config`: Enable post-authentication config download (flag; disabled by default).
- `--vulnerable-file <path>`: File to save vulnerable targets (default: `vulnerable_targets.txt`).
- `--output-file <path>`: CSV file for attack reports (default: `attack_report.csv`).

**Note:** If no target options are provided, the script will exit with an error.

### Examples

1. **Single Target Scan:**
   ```
   python exploit.py --target 192.168.1.1 --username admin --proxy http://127.0.0.1:8080
   ```
   Scans a single device, impersonating `admin`, via a local proxy.

2. **Bulk Scan from List:**
   ```
   python exploit.py --targets 192.168.1.1,example.com --max-threads 20 --post-auth-config
   ```
   Scans multiple targets in parallel, enables config download on success.

3. **File-Based Scan with Token Replay:**
   ```
   python exploit.py --file targets.txt --saml-token <base64_token> --endpoint /custom/saml
   ```
   Processes targets from `targets.txt`, attempts token replay/hijacking.

4. **Non-Interactive Full Scan:**
   ```
   python exploit.py --file targets.txt --username superadmin --max-threads 15 --post-auth-config --output-file results.csv
   ```
   Custom username, high threads, config download, custom output.

## How It Works

1. **Input Parsing:** Collects targets, options via CLI args.
2. **SAML Payload:** Generates a forged, unsigned SAML response with dynamic timestamps and target-specific fields.
3. **Exploit Attempt:** Sends POST request to the SAML endpoint; checks for success (200/302 + keywords like "dashboard").
4. **Post-Exploitation:**
   - Logs cookies and URL.
   - Optionally downloads config via `/api/v2/monitor/system/config/backup`.
   - Simulates replay/hijacking if token provided (using new sessions).
5. **Output:** Vulnerable details to TXT, attack metrics to CSV (e.g., target, attack type, result, status).
6. **Error Handling:** Robust catches for network issues, file I/O, invalid inputs; logs errors without crashing.

## Output Format

- **Console Logs:** Real-time progress, successes, warnings, errors.
- **vulnerable_targets.txt:** List of vulnerable devices with cookies and URLs.
- **attack_report.csv:** Structured report with columns: Target, Username, Attack Type (e.g., Config Download, SAML Token Replay), Result (Success/Failed), Status Code.

Example CSV Row:
```
Target,Username,Attack Type,Result,Status Code
https://192.168.1.1,admin,Config Download,Success,200
```

## Limitations

- **False Positives/Negatives:** Assumes FortiCloud SSO is enabled; may fail if disabled or on patched versions.
- **Network Dependencies:** Requires direct/proxy access to targets; timeouts after 15 seconds.
- **Token Features:** Replay/hijacking are simulations; actual session theft requires custom logic.
- **Thread Safety:** Uses locks for file writes; high threads may strain resources.
- **No Persistence:** Does not maintain sessions beyond single runs.

## Troubleshooting

- **Connection Errors:** Check network/firewall; use `--proxy` for debugging.
- **Invalid Targets:** Ensure IPs/hostnames are resolvable; no protocol prefix needed.
- **Dependency Issues:** Verify `requests` and `argparse` are installed.
- **Large Scans:** Reduce `--max-threads` if resource limits are hit.

## Contributing

This is a PoC; contributions for improvements (e.g., better detection, additional features) are welcome via pull requests. Focus on safety and ethics.

## References

- Fortinet Advisory: [FG-IR-25-647](https://www.fortiguard.com/psirt/FG-IR-25-647)
- CVE Details: [CVE-2025-59718](https://nvd.nist.gov/vuln/detail/CVE-2025-59718)
- Related: Often paired with CVE-2025-59719 in attacks.

*Last Updated: December 22, 2025*
