# CVE‑2025‑5964 Path Traversal PoC for M‑Files

> **Author:** Byte Reaper  
> **Telegram:** @ByteReaper0

---

## Overview

This repository contains a **Proof‑of‑Concept (PoC)** in C for a suspected **Path Traversal** vulnerability in **M‑Files** version **25.6.14925.0**.  
The PoC (file `exploit.c`) attempts to read sensitive files (e.g. `/etc/passwd`) by injecting traversal payloads into REST API endpoints.

---

## Important Notice

- **Not a confirmed exploit**:  
  All parameters and endpoints were derived from public documentation and OSINT.  
  **I do *not* have access** to a licensed or demo instance of M‑Files to verify this for real.

- **Use responsibly**:  
  Do *not* run against systems you don’t own or have explicit permission to test.  
  This code is provided for research and authorized security testing only.

- **Contact**:  
  If you have access to a working M‑Files 25.6.14925.0 instance (free trial or licensed), please get in touch on Telegram to refine this PoC:  
  **@ByteReaper0**

---

##  Files

| Filename      | Description                                                      |
|---------------|------------------------------------------------------------------|
| `exploit.c`   | Main PoC source; sends traversal payloads to M‑Files REST API    |
| `argparse.c`  | Simple command‑line parsing helper                              |
| `argparse.h`  | Header for `argparse.c`                                          |
| `README.md`   | This documentation                                              |

---

## Building

You need:
- **GCC** (or any modern C compiler)
- **libcurl** development headers
- **pthread** (only if you later add threading)

# On Debian/Ubuntu:
sudo apt update && sudo apt install build-essential libcurl4-openssl-dev

# Compile:
gcc exploit.c argparse.c -o CVE-2025-5964 -lcurl


## Usage

./CVE-2025-5964 -u <TARGET_URL>
Replace <TARGET_URL> with your M‑Files endpoint, for example:

./CVE-2025-5964 -u http://192.168.0.10
The PoC will iterate a set of traversal payloads against these query parameters:

?q=

?o=

?d=

It prints each tested URL, the HTTP response code (e.g. 200 or 404), and flags any response containing common filesystem markers (root:x:, /bin/bash, etc.) as a “Potential LFI hit.”

## How It Works
Agent Rotation
Rotates through a list of realistic User‑Agent strings to help bypass naive filtering.

Traversal Payloads
A variety of ../, URL‑encoded and Base64 variants to maximize chance of bypass.

Response Analysis

200 OK + presence of UNIX file markers ⇒ flagged as potential success.

All other status codes are still logged for manual review.

Throttling
A 1 second sleep() between requests to avoid tripping simple rate‑limits or WAF rules.

## Extending & Customization
Add more payloads: edit the payloads[] array in exploit.c.

Custom headers: extend agentSend() or add curl_slist_append() calls.

Responsible Disclosure & Disclaimer
Research Only
This code is intended for security research, responsible disclosure, and private testing.

No Warranty
Provided “as‑is” with no guarantee of functionality or safety.

Legal
Running this PoC against unauthorized targets may violate laws. Always obtain permission.

## Contact
Byte Reaper
Telegram: @ByteReaper0
