# CVE-2025-59501

POC that abuses SCCM's AdminService API when Entra ID integration is enabled to elevate to Full Administrator and takeover an SCCM hierarchy. More details can be found in this [blog](https://specterops.io/blog/2025/11/19/sccm-hierarchy-takeover-via-entra-integrationbecause-of-the-implication/)

# Requirements

[uv](https://docs.astral.sh/uv/getting-started/installation/)

# Install

```
git clone https://github.com/garrettfoster13/CVE-2025-59501.git
cd CVE-2025-59501/
uv sync
```

# Usage

The tool has two modules, token and admin

```
➜  CVE-2025-59501 git:(main) ✗ uv run poc.py
usage: poc.py [-h] {token,admin} ...

POC to abuse CVE-2025-59501 by @unsigned_sh0rt

positional arguments:
  {token,admin}
    token        Get AdminService access token
    admin        Add user as SCCM admin

options:
  -h, --help     show this help message and exit

```
The token module is used to request an access token as an entra/AD user with a UPN you want to impersonate
```
➜  CVE-2025-59501 git:(main) ✗ uv run poc.py token -h
usage: poc.py token [-h] -u USERNAME [-p PASSWORD] -c CLIENT_ID -t TENANT_ID [-s SCOPE]

options:
  -h, --help            show this help message and exit
  -u, --username USERNAME
                        username
  -p, --password PASSWORD
                        password
  -c, --client-id CLIENT_ID
                        azure app clientid
  -t, --tenant-id TENANT_ID
                        entra tenant ID
  -s, --scope SCOPE     resource URI/Scope

```
The admin module uses the token to authenticate to the AdminService API to add a target user account as an SCCM admin
```
➜  CVE-2025-59501 git:(main) ✗ uv run poc.py admin -h
usage: poc.py admin [-h] -t TARGET -u USER -s SID -a ACCESS_TOKEN

options:
  -h, --help            show this help message and exit
  -t, --target TARGET   target SMS provider FQDN or IP address
  -u, --user USER       Username to add as admin
  -s, --sid SID         New admins user's SID
  -a, --access-token ACCESS_TOKEN
                        AdminService access token
```
