# CVE-2025-59390-
The attached POC will allow you to crack the Kerberos signiture in Apache Druid and also, any integer created by ThreadLocalRandom

Advisory - Apache Druid’s Kerberos authenticator uses a weak fallback secret when the `druid.auth.authenticator.kerberos.cookieSignatureSecret` configuration is not explicitly set. In this case, the secret is generated using `ThreadLocalRandom`, which is not a crypto-graphically secure random number generator. This may allow an attacker to predict or brute force the secret used to sign authentication cookies, potentially enabling token forgery or authentication bypass. Additionally, each process generates its own fallback secret, resulting in inconsistent secrets across nodes. This causes authentication failures in distributed or multi-broker deployments, effectively leading to a incorrectly configured clusters. Users are advised to configure a strong `druid.auth.authenticator.kerberos.cookieSignatureSecret` This issue affects Apache Druid: through 34.0.0. Users are recommended to upgrade to version 35.0.0, which fixes the issue making it mandatory to set `druid.auth.authenticator.kerberos.cookieSignatureSecret` when using the Kerberos authenticator. Services will fail to come up if the secret is not set.


