# CVE-2025-58440
Remote Code Execution (RCE) via Polyglot File Attack and Null Byte Injection on Laravel FileManager

### Overview

The  **unisharp/laravel-filemanager** package versions  `2.11` are vulnerable to **Remote Code Execution (RCE)** due to improper file type validation during file uploads. The vulnerability allows an attacker to upload a malicious PHP file disguised as a GIF image by exploiting the file extension validation. Specifically, the attacker can append a period (`.`) to the `.php` file extension and include the `GIF89a;` header to make the file appear as an image, bypassing validation checks. This allows the attacker to execute arbitrary PHP code on the server, leading to **Remote Code Execution (RCE)**.

- [Docker Setup Demo](https://github.com/ph-hitachi/laravel-filemanager-docker)
  
### Usage

```python
python3 CVE-2025-58440.py <target> [--flags]

Laravel File Manager  Exploit (CVE-2025-58440)

positional arguments:
  target                Target URL (e.g., 127.0.0.1:8000)

options:
  -h, --help                           show this help message and exit
  -C, --cookie COOKIE                  Session cookies
  -d, --directory DIRECTORY            Working directory (default: /tmp)
  -f, --filename FILENAME              Filename to upload (default: random)
  -p, --payload COMMAND                Command to execute through the webshell (e.g., 'id', 'whoami') (default: id)
```

### Proof of Concept
```
python3 CVE-2025-58440.py 127.0.0.1:8000 -C "laravel-session=value" -p "whoami"
```
<img width="731" height="231" alt="image" src="https://github.com/user-attachments/assets/25712ff0-6300-4b13-971f-a5dc06d810f6" />
